/*
 * Decompiled with CFR 0.152.
 */
package wf.utils.java.thread.loop;

import wf.utils.java.thread.loop.LoopTask;

public class ThreadLoopTask
implements LoopTask {
    private final Thread thread;
    private volatile boolean isRunning = false;
    private Runnable runnable;

    public ThreadLoopTask(Runnable runnable, long delay, long period) {
        this.runnable = runnable;
        this.thread = new Thread(() -> {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            while (this.isRunning && this.runnable != null) {
                this.runnable.run();
                try {
                    Thread.sleep(period);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.thread.setDaemon(true);
    }

    @Override
    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void start() {
        if (this.isRunning) {
            return;
        }
        this.thread.start();
        this.isRunning = true;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public ThreadLoopTask setRunnable(Runnable runnable) {
        this.runnable = runnable;
        return this;
    }
}

