/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.exceptions.InvalidUrlException;
import io.github.zero88.utils.HttpScheme;
import io.github.zero88.utils.Strings;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class Urls {
    public static final String HOST_PATTERN = "(www\\.)?(([\\w-]+\\.)+[\\w]{2,63}|[\\w-\\.]+)/?";
    public static final String AUTHORITY_PATTERN = "(www\\.)?(([\\w-]+\\.)+[\\w]{2,63}|[\\w-\\.]+)(:[1-9]\\d{1,4})?/?";
    public static final String PATH_PATTERN = "(/([\\w\\$\\-\\.\\+\\!\\*\\'\\(\\)\\,\\;\\:\\@\\&\\=]|(\\%[a-f0-9]{2}))*)*";
    public static final String URL_PATTERN = "(https?://)(www\\.)?(([\\w-]+\\.)+[\\w]{2,63}|[\\w-\\.]+)(:[1-9]\\d{1,4})?/?(/([\\w\\$\\-\\.\\+\\!\\*\\'\\(\\)\\,\\;\\:\\@\\&\\=]|(\\%[a-f0-9]{2}))*)*";
    public static final String PATH_SEP_CHAR = "/";
    public static final String QUERY_SEP_CHAR = "?";
    public static final String FRAGMENT_SEP_CHAR = "#";
    public static final String CAPTURE_PARAM = "/:";
    private static final Map<String, String> ENCODING_RULES;

    public static String optimizeURL(String base, String path) {
        if (Strings.isBlank(base) && Strings.isBlank(path)) {
            throw new IllegalArgumentException("Base URl and path are blank");
        }
        if (Urls.validateURL(path)) {
            return path;
        }
        if (Urls.validateURL(base)) {
            if (Strings.isBlank(path)) {
                return base;
            }
            String normalizePath = Urls.normalize(path);
            if (!Urls.validatePath(normalizePath)) {
                throw new InvalidUrlException("Invalid path: " + path);
            }
            return Urls.normalize(base + normalizePath);
        }
        throw new InvalidUrlException("Invalid url - Base: " + base + " - Path: " + path);
    }

    public static boolean validateHost(String url) {
        return Urls.validate(url, HOST_PATTERN);
    }

    public static boolean validateURL(String url) {
        return Urls.validate(url, URL_PATTERN);
    }

    public static boolean validatePath(String path) {
        return Urls.validate(path, PATH_PATTERN);
    }

    public static String combinePath(String ... path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return Urls.normalize(PATH_SEP_CHAR + Arrays.stream(path).filter(Strings::isNotBlank).collect(Collectors.joining(PATH_SEP_CHAR)));
    }

    public static String normalize(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        return url.replaceAll("/+", PATH_SEP_CHAR).replaceAll("^(https?:)/", "$1//");
    }

    private static boolean validate(String s, String pattern) {
        return Strings.isNotBlank(s) && Pattern.compile(pattern, 2).matcher(s).matches();
    }

    public static String buildURL(HttpScheme scheme, String host, int port) {
        if (Strings.isBlank(host)) {
            return null;
        }
        return (Object)((Object)scheme) + "://" + Urls.normalize(host) + (port < 1 ? "" : ":" + port);
    }

    public static String buildURL(String url, String query) {
        return Urls.buildURL(url, query, null);
    }

    public static String buildURL(String url, String query, String fragment) {
        return Urls.normalize(Strings.requireNotBlank(url) + Urls.buildQuery(query) + Urls.buildFragment(fragment));
    }

    private static String buildFragment(String fragment) {
        return Strings.isBlank(fragment) ? "" : FRAGMENT_SEP_CHAR + fragment;
    }

    private static String buildQuery(String query) {
        return Strings.isBlank(query) ? "" : QUERY_SEP_CHAR + query;
    }

    public static String encode(String plain) {
        Objects.requireNonNull(plain, "Cannot encode null object");
        String encoded = URLEncoder.encode(plain, StandardCharsets.UTF_8.name());
        for (Map.Entry<String, String> rule : ENCODING_RULES.entrySet()) {
            encoded = Urls.applyRule(encoded, rule.getKey(), rule.getValue());
        }
        return encoded;
    }

    public static String decode(String encoded) {
        Objects.requireNonNull(encoded, "Cannot decode null object");
        return URLDecoder.decode(encoded, StandardCharsets.UTF_8.name());
    }

    public static String capturePath(@NonNull String path, String ... params) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String p = Urls.normalize(PATH_SEP_CHAR + path);
        String pns = Arrays.stream(params).filter(Strings::isNotBlank).map(Urls::toCapture).collect(Collectors.joining());
        return Strings.isNotBlank(pns) ? Urls.normalize(p + pns) : p;
    }

    public static String capturePatternPath(@NonNull String path, String ... params) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        String p = Urls.normalize(PATH_SEP_CHAR + path);
        Object[] pns = Arrays.stream(params).filter(Strings::isNotBlank).map(Urls::toCapture).toArray(String[]::new);
        return Urls.normalize(Strings.format(p, pns));
    }

    private static String applyRule(String encoded, String toReplace, String replacement) {
        return encoded.replaceAll(Pattern.quote(toReplace), replacement);
    }

    public static String toPathWithLC(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return Strings.transform(text, false, "-").replaceAll("_", "-");
    }

    public static String toCapture(String param) {
        String s = Strings.requireNotBlank(param);
        if (s.startsWith(CAPTURE_PARAM)) {
            return s;
        }
        if (s.startsWith(PATH_SEP_CHAR)) {
            throw new InvalidUrlException("Invalid param path because of starting with /");
        }
        return CAPTURE_PARAM + s;
    }

    private Urls() {
    }

    static {
        HashMap<String, String> rules = new HashMap<String, String>();
        rules.put("*", "%2A");
        rules.put("+", "%20");
        rules.put("%7E", "~");
        ENCODING_RULES = Collections.unmodifiableMap(rules);
    }
}

