/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.repl.ReflectionClass;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;

public final class Arguments {
    private final List<Class<?>> classes = new ArrayList();
    private final List<Object> values = new ArrayList<Object>();

    public <T> Arguments put(Class<T> argClass, T argValue) {
        this.classes.add(Objects.requireNonNull(argClass, "Argument class must be not null"));
        this.values.add(argValue);
        return this;
    }

    public Class<?>[] argClasses() {
        return this.classes.toArray(new Class[0]);
    }

    public Object[] argValues() {
        return this.values.toArray(new Object[0]);
    }

    public boolean isSame(Class<?> ... argClasses) {
        if (this.classes.size() != argClasses.length) {
            return false;
        }
        return IntStream.range(0, this.classes.size()).allMatch(i -> ReflectionClass.assertDataType(argClasses[i], this.classes.get(i)));
    }

    public boolean isSame(Arguments arguments) {
        return this.isSame(arguments.argClasses());
    }

    public static Arguments from(Method method) {
        Arguments args = new Arguments();
        Arrays.stream(Arguments.getMethodArgs(method)).forEach(cls -> args.put((Class)cls, null));
        return args;
    }

    public static Arguments from(Method method, Object ... argValues) {
        Arguments args = new Arguments();
        Class[] methodArgs = Arguments.getMethodArgs(method);
        if (methodArgs.length != argValues.length) {
            throw new IllegalArgumentException("Given argument values does not match with the Method signature arguments");
        }
        IntStream.range(0, methodArgs.length).boxed().forEach(i -> args.put(methodArgs[i], Arguments.castArgValue(methodArgs[i], argValues[i])));
        return args;
    }

    private static Class<?>[] getMethodArgs(Method m) {
        return Objects.requireNonNull(m, "Given method cannot be null").getParameterTypes();
    }

    static <T> T castArgValue(Class<?> argClass, Object argValue) {
        if (argValue == null) {
            return null;
        }
        if (ReflectionClass.assertDataType(argValue.getClass(), argClass)) {
            if (argValue.getClass().isPrimitive() || argClass.isPrimitive()) {
                return (T)argValue;
            }
            return (T)argClass.cast(argValue);
        }
        throw new IllegalArgumentException("Invalid argument type. Signature[" + argClass.getName() + "] - Actual[" + argValue.getClass() + "]");
    }
}

