/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.repl;

import io.github.zero88.repl.ReflectionScanner;
import io.github.zero88.repl.SimpleReplScanner;
import io.github.zero88.utils.ServiceHelper;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reflections {
    static final Logger LOGGER = LoggerFactory.getLogger(Reflections.class);

    private Reflections() {
    }

    public static ClassLoader contextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader staticClassLoader() {
        return Reflections.class.getClassLoader();
    }

    public static ClassLoader[] classLoaders(ClassLoader ... classLoaders) {
        ClassLoader[] classLoaderArray;
        ClassLoader cscl;
        if (classLoaders != null && classLoaders.length != 0) {
            return classLoaders;
        }
        ClassLoader tccl = Reflections.contextClassLoader();
        if (tccl.equals(cscl = Reflections.staticClassLoader())) {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = tccl;
        } else {
            classLoaderArray = (ClassLoader[])Stream.of(tccl, cscl).filter(Objects::nonNull).toArray(ClassLoader[]::new);
        }
        return classLoaderArray;
    }

    public static ReflectionScanner loadScanner() {
        return Optional.ofNullable(ServiceHelper.loadFactory(ReflectionScanner.class)).orElseGet(SimpleReplScanner::new);
    }
}

