/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;

public enum HttpScheme {
    HTTP("http"),
    HTTPS("https");

    public static final String SCHEME_REGEX = "(https?://)";
    private final String scheme;

    private HttpScheme(String scheme) {
        this.scheme = scheme;
    }

    @JsonCreator
    public static HttpScheme parse(String name) {
        return Arrays.stream(HttpScheme.values()).filter(s -> s.scheme.equalsIgnoreCase(name)).findFirst().orElse(HTTP);
    }

    public String toString() {
        return this.scheme;
    }

    public String getScheme() {
        return this.scheme;
    }
}

