/*
 * Decompiled with CFR 0.152.
 */
package io.github.zero88.utils;

import io.github.zero88.utils.Strings;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class UUID64 {
    private UUID64() {
    }

    public static String random() {
        return UUID64.uuidToBase64(UUID.randomUUID());
    }

    public static String uuidToBase64(String uuidStr) {
        return UUID64.uuidToBase64(UUID.fromString(Strings.requireNotBlank(uuidStr)));
    }

    public static String uuidToBase64(@NotNull UUID uuid) {
        byte[] bytes = UUID64.uuidToBytes(uuid);
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    public static String uuid64ToUuidStr(String uuid64) {
        return UUID64.uuid64ToUuid(uuid64).toString();
    }

    public static UUID uuid64ToUuid(String uuid64) {
        String src = Strings.requireNotBlank(uuid64);
        if (src.length() == 36) {
            return UUID.fromString(src);
        }
        if (src.length() != 22) {
            throw new IllegalArgumentException("Invalid uuid");
        }
        byte[] decoded = Base64.getUrlDecoder().decode(src);
        return UUID64.uuidFromBytes(decoded);
    }

    private static byte[] uuidToBytes(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private static UUID uuidFromBytes(byte[] decoded) {
        ByteBuffer bb = ByteBuffer.wrap(decoded);
        long mostSigBits = bb.getLong();
        long leastSigBits = bb.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }
}

