/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client;

import io.gridy.client.ApiCallback;
import io.gridy.client.ApiConfig;
import io.gridy.client.ApiException;
import io.gridy.client.ApiResponse;
import io.gridy.client.JSON;
import io.gridy.client.ProgressRequestBody;
import io.gridy.client.StringUtil;
import io.gridy.client.auth.ApiHmacAuth;
import io.gridy.client.model.GridyEnv;
import io.gridy.utils.SnowflakeID;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.tls.OkHostnameVerifier;
import okhttp3.logging.HttpLoggingInterceptor;

public class ApiClient {
    private String basePath = "https://api.gridy.io/prod";
    private String apiUser = "";
    private String apiSecret = "";
    private OkHttpClient httpClient;
    private InputStream sslCaCert;
    private boolean verifyingSsl;
    private KeyManager[] keyManagers;
    private boolean debugging = false;
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private JSON json;
    private GridyEnv apiEnv = GridyEnv.LIVE;
    private ApiHmacAuth hmacAuth;
    private HttpLoggingInterceptor loggingInterceptor;

    public ApiClient() throws Exception {
        this.init();
        this.initHttpClient();
    }

    public ApiClient(OkHttpClient client) throws Exception {
        this.init();
        this.httpClient = client;
    }

    public ApiClient(ApiConfig.Builder bldr) throws Exception {
        this.apiUser = bldr.getApiUser();
        this.apiSecret = bldr.getApiSecret();
        this.apiEnv = bldr.getApiEnv();
        if (this.apiEnv == null) {
            this.apiEnv = GridyEnv.LIVE;
        }
        switch (this.apiEnv) {
            case LIVE: {
                this.basePath = "https://api.gridy.io/prod";
                break;
            }
            case UAT: {
                this.basePath = "https://api.gridy.io/uat";
                break;
            }
            case CUSTOM: {
                this.basePath = bldr.getCustomApiUrl();
                break;
            }
            default: {
                this.basePath = "https://api.gridy.io/prod";
            }
        }
        this.init();
        this.initHttpClient();
    }

    private void initHttpClient() {
        this.initHttpClient(Collections.emptyList());
    }

    private void initHttpClient(List<Interceptor> interceptors) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        for (Interceptor interceptor : interceptors) {
            builder.addInterceptor(interceptor);
        }
        this.httpClient = builder.build();
    }

    private void init() throws Exception {
        if (this.apiUser.equals("") || this.apiSecret.equals("")) {
            throw new IllegalArgumentException("Missing the required parameter 'apiUser' or 'apiSecretKey' when creating api client.");
        }
        this.verifyingSsl = true;
        this.json = new JSON();
        this.hmacAuth = new ApiHmacAuth(this.apiUser, this.apiSecret);
        this.setUserAgent("gridy-id-java-v0.5.0");
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ApiClient setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public String getApiUser() {
        return this.apiUser;
    }

    public ApiClient setApiUser(String apiUser) {
        this.apiUser = apiUser;
        this.hmacAuth.setApiUser(apiUser);
        return this;
    }

    public String getApiSecret() {
        return this.apiUser;
    }

    public ApiClient setApiSecret(String apiSecret) {
        this.apiSecret = apiSecret;
        this.hmacAuth.setSecretKey(apiSecret);
        return this;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public ApiClient setHttpClient(OkHttpClient newHttpClient) {
        this.httpClient = Objects.requireNonNull(newHttpClient, "HttpClient must not be null!");
        return this;
    }

    public JSON getJSON() {
        return this.json;
    }

    public ApiClient setJSON(JSON json) {
        this.json = json;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ApiClient setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        this.applySslSettings();
        return this;
    }

    public InputStream getSslCaCert() {
        return this.sslCaCert;
    }

    public ApiClient setSslCaCert(InputStream sslCaCert) {
        this.sslCaCert = sslCaCert;
        this.applySslSettings();
        return this;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public ApiClient setKeyManagers(KeyManager[] managers) {
        this.keyManagers = managers;
        this.applySslSettings();
        return this;
    }

    public ApiClient setLenientOnJson(boolean lenientOnJson) {
        JSON.setLenientOnJson(lenientOnJson);
        return this;
    }

    public ApiClient setUserAgent(String userAgent) {
        this.addDefaultHeader("User-Agent", userAgent);
        return this;
    }

    public ApiClient addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
        return this;
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public ApiClient setDebugging(boolean debugging) {
        if (debugging != this.debugging) {
            if (debugging) {
                this.loggingInterceptor = new HttpLoggingInterceptor();
                this.loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                this.httpClient = this.httpClient.newBuilder().addInterceptor((Interceptor)this.loggingInterceptor).build();
            } else {
                OkHttpClient.Builder builder = this.httpClient.newBuilder();
                builder.interceptors().remove(this.loggingInterceptor);
                this.httpClient = builder.build();
                this.loggingInterceptor = null;
            }
        }
        this.debugging = debugging;
        return this;
    }

    public SnowflakeID createDefaultIDGenerator() {
        SnowflakeID snowflakeIDGen = new SnowflakeID(0L);
        return snowflakeIDGen;
    }

    public int getConnectTimeout() {
        return this.httpClient.connectTimeoutMillis();
    }

    public ApiClient setConnectTimeout(int connectionTimeout) {
        this.httpClient = this.httpClient.newBuilder().connectTimeout((long)connectionTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getReadTimeout() {
        return this.httpClient.readTimeoutMillis();
    }

    public ApiClient setReadTimeout(int readTimeout) {
        this.httpClient = this.httpClient.newBuilder().readTimeout((long)readTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public int getWriteTimeout() {
        return this.httpClient.writeTimeoutMillis();
    }

    public ApiClient setWriteTimeout(int writeTimeout) {
        this.httpClient = this.httpClient.newBuilder().writeTimeout((long)writeTimeout, TimeUnit.MILLISECONDS).build();
        return this;
    }

    public boolean isJsonMime(String mime) {
        String jsonMime = "(?i)^(application/json|[^;/ \t]+/[^;/ \t]+[+]json)[ \t]*(;.*)?$";
        return mime != null && (mime.matches(jsonMime) || mime.equals("*/*"));
    }

    public String selectHeaderAccept(String[] accepts) {
        if (accepts.length == 0) {
            return null;
        }
        for (String accept : accepts) {
            if (!this.isJsonMime(accept)) continue;
            return accept;
        }
        return StringUtil.join(accepts, ",");
    }

    public String selectHeaderContentType(String[] contentTypes) {
        if (contentTypes.length == 0) {
            return null;
        }
        if (contentTypes[0].equals("*/*")) {
            return "application/json";
        }
        for (String contentType : contentTypes) {
            if (!this.isJsonMime(contentType)) continue;
            return contentType;
        }
        return contentTypes[0];
    }

    public String escapeString(String str) {
        try {
            return URLEncoder.encode(str, "utf8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public <T> T deserialize(Response response, Type returnType) throws ApiException {
        String respBody;
        if (response == null || returnType == null) {
            return null;
        }
        try {
            respBody = response.body() != null ? response.body().string() : null;
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        if (respBody == null || "".equals(respBody)) {
            return null;
        }
        String contentType = response.headers().get("Content-Type");
        if (contentType == null) {
            contentType = "application/json";
        }
        if (this.isJsonMime(contentType)) {
            return JSON.deserialize(respBody, returnType);
        }
        if (returnType.equals(String.class)) {
            return (T)respBody;
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported for type: " + returnType, response.code(), (Map<String, List<String>>)response.headers().toMultimap(), respBody);
    }

    public RequestBody serialize(Object obj, String contentType) throws ApiException {
        if ("text/plain".equals(contentType) && obj instanceof String) {
            return RequestBody.create((String)((String)obj), (MediaType)MediaType.parse((String)contentType));
        }
        if (this.isJsonMime(contentType)) {
            String content = obj != null ? JSON.serialize(obj) : null;
            return RequestBody.create((String)content, (MediaType)MediaType.parse((String)contentType));
        }
        if (obj instanceof String) {
            return RequestBody.create((String)((String)obj), (MediaType)MediaType.parse((String)contentType));
        }
        throw new ApiException("Content type \"" + contentType + "\" is not supported");
    }

    public <T> ApiResponse<T> execute(Call call) throws ApiException {
        return this.execute(call, null);
    }

    public <T> ApiResponse<T> execute(Call call, Type returnType) throws ApiException {
        try {
            Response response = call.execute();
            T data = this.handleResponse(response, returnType);
            return new ApiResponse<T>(response.code(), response.headers().toMultimap(), data);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
    }

    public <T> void executeAsync(Call call, ApiCallback<T> callback) {
        this.executeAsync(call, null, callback);
    }

    public <T> void executeAsync(Call call, final Type returnType, final ApiCallback<T> callback) {
        call.enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(new ApiException(e), 0, null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                Object result;
                try {
                    result = ApiClient.this.handleResponse(response, returnType);
                }
                catch (ApiException e) {
                    callback.onFailure(e, response.code(), response.headers().toMultimap());
                    return;
                }
                catch (Exception e) {
                    callback.onFailure(new ApiException(e), response.code(), response.headers().toMultimap());
                    return;
                }
                callback.onSuccess(result, response.code(), response.headers().toMultimap());
            }
        });
    }

    public <T> T handleResponse(Response response, Type returnType) throws ApiException {
        if (returnType == null || response.code() == 204) {
            if (response.body() != null) {
                try {
                    response.body().close();
                }
                catch (Exception e) {
                    throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                }
            }
            return null;
        }
        return this.deserialize(response, returnType);
    }

    public Call buildCall(String baseUrl, String path, String method, Object body, Map<String, String> headerParams, ApiCallback callback) throws ApiException {
        Request request = this.buildRequest(baseUrl, path, method, body, headerParams, callback);
        return this.httpClient.newCall(request);
    }

    public Request buildRequest(String baseUrl, String path, String method, Object body, Map<String, String> headerParams, ApiCallback callback) throws ApiException {
        String url = this.buildUrl(baseUrl, path);
        String contentType = headerParams.get("Content-Type");
        String contentTypePure = contentType;
        if (contentTypePure != null && contentTypePure.contains(";")) {
            contentTypePure = contentType.substring(0, contentType.indexOf(";"));
        }
        RequestBody reqBody = !HttpMethod.permitsRequestBody((String)method) ? null : (body == null ? RequestBody.create((String)"", (MediaType)(contentType == null ? null : MediaType.parse((String)contentType))) : this.serialize(body, contentType));
        Request.Builder reqBuilder = new Request.Builder().url(this.buildUrl(baseUrl, path));
        this.hmacAuth.generateNewHmac();
        headerParams.put("x-gridy-apiuser", this.hmacAuth.getApiUser());
        headerParams.put("x-gridy-utctime", this.hmacAuth.getUtcTime());
        headerParams.put("x-gridy-cnonce", this.hmacAuth.getcNonce());
        headerParams.put("Authorization", this.hmacAuth.getHmacAuthHdr());
        this.processHeaderParams(headerParams, reqBuilder);
        reqBuilder.tag((Object)callback);
        Request request = null;
        if (callback != null && reqBody != null) {
            ProgressRequestBody progressRequestBody = new ProgressRequestBody(reqBody, callback);
            request = reqBuilder.method(method, (RequestBody)progressRequestBody).build();
        } else {
            request = reqBuilder.method(method, reqBody).build();
        }
        return request;
    }

    public String buildUrl(String baseUrl, String path) {
        StringBuilder url = new StringBuilder();
        if (baseUrl != null) {
            url.append(baseUrl).append(path);
        } else {
            String baseURL = this.basePath;
            url.append(baseURL).append(path);
        }
        return url.toString();
    }

    public void processHeaderParams(Map<String, String> headerParams, Request.Builder reqBuilder) {
        for (Map.Entry<String, String> param : headerParams.entrySet()) {
            reqBuilder.header(param.getKey(), this.parameterToString(param.getValue()));
        }
        for (Map.Entry<String, String> header : this.defaultHeaderMap.entrySet()) {
            if (headerParams.containsKey(header.getKey())) continue;
            reqBuilder.header(header.getKey(), this.parameterToString(header.getValue()));
        }
    }

    public String parameterToString(Object param) {
        if (param == null) {
            return "";
        }
        if (param instanceof Date || param instanceof OffsetDateTime || param instanceof LocalDate) {
            String jsonStr = JSON.serialize(param);
            return jsonStr.substring(1, jsonStr.length() - 1);
        }
        if (param instanceof Collection) {
            StringBuilder b = new StringBuilder();
            for (Object o : (Collection)param) {
                if (b.length() > 0) {
                    b.append(",");
                }
                b.append(o);
            }
            return b.toString();
        }
        return String.valueOf(param);
    }

    private void applySslSettings() {
        try {
            HostnameVerifier hostnameVerifier;
            TrustManager[] trustManagers;
            if (!this.verifyingSsl) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }
                }};
                hostnameVerifier = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
            } else {
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                if (this.sslCaCert == null) {
                    trustManagerFactory.init((KeyStore)null);
                } else {
                    char[] password = null;
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(this.sslCaCert);
                    if (certificates.isEmpty()) {
                        throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                    }
                    KeyStore caKeyStore = this.newEmptyKeyStore(password);
                    int index = 0;
                    for (Certificate certificate : certificates) {
                        String certificateAlias = "ca" + index++;
                        caKeyStore.setCertificateEntry(certificateAlias, certificate);
                    }
                    trustManagerFactory.init(caKeyStore);
                }
                trustManagers = trustManagerFactory.getTrustManagers();
                hostnameVerifier = OkHostnameVerifier.INSTANCE;
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(this.keyManagers, trustManagers, new SecureRandom());
            this.httpClient = this.httpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)trustManagers[0]).hostnameVerifier(hostnameVerifier).build();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore newEmptyKeyStore(char[] password) throws GeneralSecurityException {
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, password);
            return keyStore;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

