/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client;

import io.gridy.client.ApiClient;
import io.gridy.client.model.GridyEnv;

public class ApiConfig {

    public static class Builder {
        private String apiUser;
        private String apiSecret;
        private GridyEnv apiEnv;
        private String customUrl;

        public Builder withApiUser(String u) {
            this.apiUser = u;
            return this;
        }

        public Builder withApiSecret(String s) {
            this.apiSecret = s;
            return this;
        }

        public Builder withApiEnv(GridyEnv e) {
            this.apiEnv = e;
            return this;
        }

        public Builder withCustomApiUrl(String e) {
            this.customUrl = e;
            return this;
        }

        public ApiClient build() throws Exception {
            return new ApiClient(this);
        }

        public String getApiUser() {
            return this.apiUser;
        }

        public String getApiSecret() {
            return this.apiSecret;
        }

        public GridyEnv getApiEnv() {
            return this.apiEnv;
        }

        public String getCustomApiUrl() {
            return this.customUrl;
        }
    }
}

