/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client.api;

import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import io.gridy.client.ApiCallback;
import io.gridy.client.ApiClient;
import io.gridy.client.ApiException;
import io.gridy.client.ApiResponse;
import io.gridy.client.model.ApiRequest;
import io.gridy.client.model.BlockedRequest;
import io.gridy.client.model.ChallengeRequest;
import io.gridy.client.model.ModelApiResponse;
import io.gridy.client.model.Status;
import io.gridy.client.model.StatusRequest;
import io.gridy.client.model.SysTime;
import io.gridy.client.model.VerifyRequest;
import io.gridy.utils.AutoVerifyListener;
import io.gridy.utils.ResponseListener;
import io.gridy.utils.SnowflakeID;
import io.gridy.utils.VerifyListener;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import okhttp3.Call;

public class GridyIdServiceApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private SnowflakeID apiIDGen;

    public GridyIdServiceApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
        this.apiIDGen = apiClient.createDefaultIDGenerator();
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    private void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call challengeCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApiRequest localVarPostBody = apiRequest;
        String localVarPath = "/v1/svc/challenge";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json; charset=utf-8"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarPostBody, localVarHeaderParams, _callback);
    }

    private Call challengeValidateBeforeCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        if (apiRequest == null) {
            throw new ApiException("Missing the required parameter 'apiRequest' when calling challenge(Async)");
        }
        return this.challengeCall(apiRequest, _callback);
    }

    public void challengeWithAutoVerify(ChallengeRequest challengeRequest, final AutoVerifyListener listener) throws ApiException {
        if (challengeRequest.getStatus().equals((Object)Status.NEW) && (challengeRequest.getUserName() == null || challengeRequest.getChallngeType() == null)) {
            throw new ApiException("Missing the required parameter 'userName' or 'challengeType' when calling challenge");
        }
        if (challengeRequest.getStatus().equals((Object)Status.CANCEL)) {
            throw new ApiException("Invalid challenge status 'CANCEL' ");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(challengeRequest.toJson()).type(150);
        ApiResponse<ModelApiResponse> r = this.challengeWithHttpInfo(apiRequest);
        switch (r.getStatusCode()) {
            case 202: {
                listener.onChallenge(r.getData());
                String challengeID = JsonParser.parseString((String)r.getData().getMessage()).getAsJsonObject().get("challengeId").getAsString();
                this.verifyAuto(new VerifyRequest.Builder().forUser(challengeRequest.getUserName()).withId(challengeID).build(), new VerifyListener(){

                    @Override
                    public void onVerified(ModelApiResponse r) {
                        listener.onVerified(r);
                    }

                    @Override
                    public void onPending() {
                        listener.onPending();
                    }

                    @Override
                    public void onExpired(ModelApiResponse r) {
                        listener.onExpired(r);
                    }

                    @Override
                    public void onRejected(ModelApiResponse r) {
                        listener.onRejected(r);
                    }

                    @Override
                    public void onError(int code) {
                        listener.onError(code);
                    }
                });
                break;
            }
            case 400: {
                listener.onChallengeError(r.getData().getCode());
                break;
            }
            case 500: {
                listener.onChallengeError(r.getStatusCode());
                break;
            }
            default: {
                listener.onChallengeError(r.getStatusCode());
            }
        }
    }

    public void challenge(ChallengeRequest challengeRequest, ResponseListener listener) throws ApiException {
        if (challengeRequest.getStatus().equals((Object)Status.NEW) && (challengeRequest.getUserName() == null || challengeRequest.getChallngeType() == null)) {
            throw new ApiException("Missing the required parameter 'userName' or 'challengeType' when calling challenge");
        }
        if (challengeRequest.getStatus().equals((Object)Status.CANCEL) && challengeRequest.getId() == null) {
            throw new ApiException("Missing the required parameter 'id' when calling challenge cancel");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(challengeRequest.toJson()).type(challengeRequest.getStatus() == Status.NEW ? 150 : 151);
        ApiResponse<ModelApiResponse> localVarResp = this.challengeWithHttpInfo(apiRequest);
        listener.onResponse(localVarResp.getData());
    }

    public ModelApiResponse challenge(ChallengeRequest challengeRequest) throws ApiException {
        if (challengeRequest.getStatus().equals((Object)Status.NEW) && (challengeRequest.getUserName() == null || challengeRequest.getChallngeType() == null)) {
            throw new ApiException("Missing the required parameter 'userName' or 'challengeType' when calling challenge");
        }
        if (challengeRequest.getStatus().equals((Object)Status.CANCEL) && challengeRequest.getId() == null) {
            throw new ApiException("Missing the required parameter 'id' when calling challenge cancel");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(challengeRequest.toJson()).type(challengeRequest.getStatus() == Status.NEW ? 150 : 151);
        ApiResponse<ModelApiResponse> localVarResp = this.challengeWithHttpInfo(apiRequest);
        return localVarResp.getData();
    }

    private ApiResponse<ModelApiResponse> challengeWithHttpInfo(ApiRequest apiRequest) throws ApiException {
        Call localVarCall = this.challengeValidateBeforeCall(apiRequest, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call challengeAsync(ChallengeRequest challengeRequest, ApiCallback<ModelApiResponse> _callback) throws ApiException {
        if (challengeRequest.getStatus().equals((Object)Status.NEW) && (challengeRequest.getUserName() == null || challengeRequest.getChallngeType() == null)) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeType' when calling challenge");
        }
        if (challengeRequest.getStatus().equals((Object)Status.CANCEL) && challengeRequest.getId() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'id' when calling challenge cancel");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(challengeRequest.toJson()).type(challengeRequest.getStatus() == Status.NEW ? 150 : 151);
        Call localVarCall = this.challengeValidateBeforeCall(apiRequest, _callback);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call statusCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApiRequest localVarPostBody = apiRequest;
        String localVarPath = "/v1/svc/status";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json; charset=utf-8"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarPostBody, localVarHeaderParams, _callback);
    }

    private Call statusValidateBeforeCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        if (apiRequest == null) {
            throw new ApiException("Missing the required parameter 'apiRequest' when calling status(Async)");
        }
        return this.statusCall(apiRequest, _callback);
    }

    public void status(StatusRequest statusRequest, ResponseListener listener) throws ApiException {
        if (statusRequest.getUserName() == null && statusRequest.getChallngeId() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' when calling status");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(statusRequest.toJson()).type(171);
        ApiResponse<ModelApiResponse> localVarResp = this.statusWithHttpInfo(apiRequest);
        listener.onResponse(localVarResp.getData());
    }

    public ModelApiResponse status(StatusRequest statusRequest) throws ApiException {
        if (statusRequest.getUserName() == null && statusRequest.getChallngeId() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' when calling status");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(statusRequest.toJson()).type(171);
        ApiResponse<ModelApiResponse> localVarResp = this.statusWithHttpInfo(apiRequest);
        return localVarResp.getData();
    }

    private ApiResponse<ModelApiResponse> statusWithHttpInfo(ApiRequest apiRequest) throws ApiException {
        Call localVarCall = this.statusValidateBeforeCall(apiRequest, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call statusAsync(StatusRequest statusRequest, ApiCallback<ModelApiResponse> _callback) throws ApiException {
        if (statusRequest.getUserName() == null && statusRequest.getChallngeId() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' when calling status");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(statusRequest.toJson()).type(171);
        Call localVarCall = this.statusValidateBeforeCall(apiRequest, _callback);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call timeCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v1/svc/time";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarPostBody, localVarHeaderParams, _callback);
    }

    private Call timeValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.timeCall(_callback);
    }

    public void time(ResponseListener listener) throws ApiException {
        ApiResponse<ModelApiResponse> localVarResp = this.timeWithHttpInfo();
        listener.onResponse(localVarResp.getData());
    }

    public ModelApiResponse time() throws ApiException {
        ApiResponse<ModelApiResponse> localVarResp = this.timeWithHttpInfo();
        return localVarResp.getData();
    }

    private ApiResponse<ModelApiResponse> timeWithHttpInfo() throws ApiException {
        Call localVarCall = this.timeValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call timeAsync(ApiCallback<ModelApiResponse> _callback) throws ApiException {
        Call localVarCall = this.timeValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call verifyCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApiRequest localVarPostBody = apiRequest;
        String localVarPath = "/v1/svc/verify";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json; charset=utf-8"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarPostBody, localVarHeaderParams, _callback);
    }

    private Call verifyValidateBeforeCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        if (apiRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'apiRequest' when calling verify(Async)");
        }
        return this.verifyCall(apiRequest, _callback);
    }

    public void verify(VerifyRequest verifyRequest, ResponseListener listener) throws ApiException {
        if (verifyRequest.getUserName() == null || verifyRequest.getChallngeId() == null || verifyRequest.getAuthCode() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' or 'authCode' when calling verify");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(verifyRequest.toJson()).type(170);
        ApiResponse<ModelApiResponse> localVarResp = this.verifyWithHttpInfo(apiRequest);
        listener.onResponse(localVarResp.getData());
    }

    public ModelApiResponse verify(VerifyRequest verifyRequest) throws ApiException {
        if (verifyRequest.getUserName() == null || verifyRequest.getChallngeId() == null || verifyRequest.getAuthCode() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' or 'authCode' when calling verify");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(verifyRequest.toJson()).type(170);
        ApiResponse<ModelApiResponse> localVarResp = this.verifyWithHttpInfo(apiRequest);
        return localVarResp.getData();
    }

    public void verifyAuto(final VerifyRequest verifyRequest, final VerifyListener verifyListener) throws ApiException {
        if (verifyRequest.getUserName() == null || verifyRequest.getChallngeId() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' when calling autoverify");
        }
        final ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(verifyRequest.toJson()).type(171);
        if (!verifyRequest.isUseSSE()) {
            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){
                long tickTime = 10000L;
                long startTime = 0L;
                long currentTime = 0L;
                long maxTimeout = verifyRequest.getExpiryInt() * 60 * 1000;
                boolean shutdown = false;

                void setCurrentTime() {
                    this.currentTime += this.tickTime;
                }

                @Override
                public void run() {
                    this.setCurrentTime();
                    if (this.currentTime >= this.maxTimeout) {
                        timer.cancel();
                    }
                    if (this.shutdown) {
                        timer.cancel();
                    }
                    try {
                        ApiResponse localVarResp = GridyIdServiceApi.this.statusWithHttpInfo(apiRequest);
                        block1 : switch (localVarResp.getStatusCode()) {
                            case 400: {
                                switch (((ModelApiResponse)localVarResp.getData()).getCode()) {
                                    case -2017: {
                                        verifyListener.onRejected((ModelApiResponse)localVarResp.getData());
                                        this.shutdown = true;
                                        break block1;
                                    }
                                    case -3092: {
                                        verifyListener.onRejected((ModelApiResponse)localVarResp.getData());
                                        this.shutdown = true;
                                        break block1;
                                    }
                                    case -3091: {
                                        verifyListener.onPending();
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case 404: {
                                verifyListener.onError(404);
                                this.shutdown = true;
                                break;
                            }
                            case 200: {
                                verifyListener.onVerified((ModelApiResponse)localVarResp.getData());
                                this.shutdown = true;
                                break;
                            }
                            case 500: {
                                verifyListener.onError(500);
                                this.shutdown = true;
                            }
                        }
                    }
                    catch (ApiException ex) {
                        System.out.println(ex.fillInStackTrace());
                    }
                }
            }, 1000L, 10000L);
        }
    }

    private ApiResponse<ModelApiResponse> verifyWithHttpInfo(ApiRequest apiRequest) throws ApiException {
        Call localVarCall = this.verifyValidateBeforeCall(apiRequest, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call verifyAsync(VerifyRequest verifyRequest, ApiCallback<ModelApiResponse> _callback) throws ApiException {
        if (verifyRequest.getUserName() == null || verifyRequest.getChallngeId() == null || verifyRequest.getAuthCode() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'challengeId' or 'authCode' when calling verify");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(verifyRequest.toJson()).type(170);
        Call localVarCall = this.verifyValidateBeforeCall(apiRequest, _callback);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    private Call blockedCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ApiRequest localVarPostBody = apiRequest;
        String localVarPath = "/v1/svc/blocked";
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        String[] localVarAccepts = new String[]{"application/json; charset=utf-8"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json; charset=utf-8"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarPostBody, localVarHeaderParams, _callback);
    }

    private Call blockedValidateBeforeCall(ApiRequest apiRequest, ApiCallback _callback) throws ApiException {
        if (apiRequest == null) {
            throw new IllegalArgumentException("Missing the required parameter 'apiRequest' when calling challenge(Async)");
        }
        return this.blockedCall(apiRequest, _callback);
    }

    public void blocked(BlockedRequest blockedRequest, ResponseListener listener) throws ApiException {
        if (blockedRequest.getUserName() == null && blockedRequest.getIpv4Address() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'ipv4Address' when calling blocked");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(blockedRequest.toJson()).type(950);
        ApiResponse<ModelApiResponse> localVarResp = this.challengeWithHttpInfo(apiRequest);
        listener.onResponse(localVarResp.getData());
    }

    public ModelApiResponse blocked(BlockedRequest blockedRequest) throws ApiException {
        if (blockedRequest.getUserName() == null && blockedRequest.getIpv4Address() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'ipv4Address' when calling blocked");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(blockedRequest.toJson()).type(950);
        ApiResponse<ModelApiResponse> localVarResp = this.challengeWithHttpInfo(apiRequest);
        return localVarResp.getData();
    }

    private ApiResponse<ModelApiResponse> blockedWithHttpInfo(ApiRequest apiRequest) throws ApiException {
        Call localVarCall = this.blockedValidateBeforeCall(apiRequest, null);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public Call blockedAsync(BlockedRequest blockedRequest, ApiCallback<ModelApiResponse> _callback) throws ApiException {
        if (blockedRequest.getUserName() == null && blockedRequest.getIpv4Address() == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userName' or 'ipv4Address' when calling blocked");
        }
        ApiRequest apiRequest = new ApiRequest().id(this.apiIDGen.getIdStr()).utcTime(new SysTime().getSystemUtcTimeMsStr()).apiUser(this.localVarApiClient.getApiUser()).body(blockedRequest.toJson()).type(950);
        Call localVarCall = this.blockedValidateBeforeCall(apiRequest, _callback);
        Type localVarReturnType = new TypeToken<ModelApiResponse>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

