/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client.auth;

import io.gridy.client.ApiException;
import io.gridy.client.model.SysTime;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;

public class ApiHmacAuth {
    private final String HMAC_SHA512_ALGORITHM = "HmacSha512";
    private String utcTime;
    private String cNonce;
    private String hmacAuthHdr;
    private String apiUser = "";
    private String secretKey = "";
    private boolean retryOnTimeError;

    public ApiHmacAuth(String apiuser, String secretkey) {
        this.apiUser = apiuser;
        this.secretKey = secretkey;
    }

    public ApiHmacAuth() {
    }

    public void generateNewHmac() throws ApiException {
        this.utcTime = new SysTime().getSystemUtcTimeMsStr();
        this.cNonce = UUID.randomUUID().toString();
        this.hmacAuthHdr = String.format("gridy-hmac: apiuser=%s,signedheaders=x-gridy-utctime;x-gridy-cnonce,algorithm=gridy-hmac512,signature=%s", this.apiUser, this.generateHmacSig());
    }

    private String generateHmacSig() throws ApiException {
        this.validateFields();
        String data = String.format("x-gridy-utctime: %s\nx-gridy-cnonce: %s", this.utcTime, this.cNonce);
        return this.calculateHmac(data);
    }

    private String calculateHmac(String content) throws ApiException {
        String hmac = null;
        byte[] rawHmac = null;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(this.secretKey.getBytes(), "HmacSha512");
            Mac mac = Mac.getInstance("HmacSha512");
            mac.init(signingKey);
            rawHmac = mac.doFinal(content.getBytes());
            hmac = Hex.encodeHexString((byte[])rawHmac);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new ApiException("Failed to generate HMAC : " + e.getMessage());
        }
        return hmac;
    }

    private void validateFields() {
        if (this.apiUser == null) {
            throw new IllegalStateException("API User required for GridyHmacAPI Auth");
        }
        if (this.secretKey == null) {
            throw new IllegalStateException("Secret Key required for GridyHmacAPI Auth");
        }
        if (this.utcTime == null) {
            throw new IllegalStateException("UTC Time required for GridyHmacAPI Auth");
        }
        if (this.cNonce == null) {
            throw new IllegalStateException("CNonce required for GridyHmacAPI Auth");
        }
    }

    public String getApiUser() {
        return this.apiUser;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getUtcTime() {
        return this.utcTime;
    }

    public String getcNonce() {
        return this.cNonce;
    }

    public String getHmacAuthHdr() {
        return this.hmacAuthHdr;
    }

    public boolean isRetryOnTimeError() {
        return this.retryOnTimeError;
    }

    public void setApiUser(String apiUser) {
        this.apiUser = apiUser;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRetryOnTimeError(boolean retryOnUTCTimeError) {
        this.retryOnTimeError = retryOnUTCTimeError;
    }
}

