/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client.model;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

public class SysTime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Instant systemUtcTime;

    public SysTime(Instant time) {
        this.systemUtcTime = time;
    }

    public SysTime() {
        this.systemUtcTime = Instant.now();
    }

    public Instant getSystemUtcTime() {
        return this.systemUtcTime;
    }

    public String getSystemUtcTimeStr() {
        return this.systemUtcTime.toString();
    }

    public long getSystemUtcTimeSecs() {
        return this.systemUtcTime.toEpochMilli() / 1000L;
    }

    public String getSystemUtcTimeSecsStr() {
        return Long.toString(this.systemUtcTime.toEpochMilli() / 1000L);
    }

    public String getSystemUtcTimeMsStr() {
        return Long.toString(this.systemUtcTime.toEpochMilli());
    }

    public long getSystemUtcTimeMillis() {
        return this.systemUtcTime.toEpochMilli();
    }

    public long getSystemUtcTimeMillisNow() {
        return Instant.now().toEpochMilli();
    }

    public LocalDateTime getLocalDateTime() {
        return LocalDateTime.ofInstant(this.systemUtcTime, ZoneId.of("UTC"));
    }
}

