/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.client.model;

import io.gridy.client.model.Expiry;
import io.gridy.client.model.Status;
import io.gridy.client.model.VerifyType;
import java.io.Serializable;

public class VerifyRequest
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String challngeId;
    private final String userName;
    private final String authCode;
    private final VerifyType type;
    private final Expiry expiry;
    private final Status status;
    private final boolean useSSE;

    public VerifyRequest(String id, String code, String username, VerifyType type, Expiry expiry, Status status) {
        this.challngeId = id;
        this.authCode = code;
        this.userName = username;
        this.type = type;
        this.expiry = expiry;
        this.status = status;
        this.useSSE = false;
    }

    public String getChallngeId() {
        return this.challngeId;
    }

    public String getUserName() {
        return this.userName;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public VerifyType getType() {
        return this.type;
    }

    public Expiry getExpiry() {
        return this.expiry;
    }

    public int getExpiryInt() {
        switch (this.expiry) {
            case ThreeMins: {
                return 3;
            }
            case FiveMins: {
                return 5;
            }
            case TenMins: {
                return 10;
            }
            case ThirtyMins: {
                return 30;
            }
            case SixtyMins: {
                return 60;
            }
        }
        return 3;
    }

    public boolean isUseSSE() {
        return this.useSSE;
    }

    public String toJson() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(" 'challngeId': ").append("'").append(this.challngeId == null ? "" : this.challngeId).append("'").append(",");
        sb.append(" 'gridyUser': ").append("'").append(this.userName == null ? "" : this.userName).append("'").append(",");
        sb.append(" 'authCode': ").append("'").append(this.authCode).append("'").append(",");
        sb.append(" 'verifyType': ").append("'").append(this.type.name()).append("'").append(",");
        sb.append(" 'expiry': ").append("'").append(this.expiry.name()).append("'").append(",");
        sb.append(" 'status': ").append("'").append(this.status.name()).append("'");
        sb.append(" }");
        return sb.toString();
    }

    public static class Builder {
        private String id;
        private String username;
        private String code;
        private VerifyType type;
        private Expiry expiry;
        private Status status;

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder forUser(String u) {
            this.username = u;
            return this;
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withVerifyType(VerifyType type) {
            this.type = type;
            return this;
        }

        public Builder withExpiry(Expiry expiry) {
            this.expiry = expiry;
            return this;
        }

        public Builder withStatus(Status status) {
            this.status = status;
            return this;
        }

        public VerifyRequest build() {
            return new VerifyRequest(this.id, this.code, this.username, this.type == null ? VerifyType.Auto : this.type, this.expiry == null ? Expiry.ThreeMins : this.expiry, this.status == null ? Status.NEW : this.status);
        }
    }
}

