/*
 * Decompiled with CFR 0.152.
 */
package io.gridy.utils;

import io.gridy.utils.IDGenerator;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Random;

public class SnowflakeID
implements IDGenerator {
    private final long datacenterIdBits = 10L;
    private final long maxDatacenterId = 1023L;
    private final long sequenceBits = 12L;
    private final long datacenterIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private final long twepoch = 1288834974657L;
    private long datacenterId;
    private volatile long lastTimestamp = -1L;
    private volatile long sequence = 0L;

    public SnowflakeID(long datacenterId) {
        if (datacenterId == 0L) {
            try {
                this.datacenterId = this.getDatacenterId();
            }
            catch (NullPointerException | SocketException | UnknownHostException e) {
                System.out.println("SNOWFLAKE: could not determine machine address; using random datacenter ID");
                Random rnd = new Random();
                this.datacenterId = rnd.nextInt(1023) + 1;
            }
        } else {
            this.datacenterId = datacenterId;
        }
        if (this.datacenterId > 1023L || datacenterId < 0L) {
            System.out.print("SNOWFLAKE: datacenterId > maxDatacenterId; using random datacenter ID");
            Random rnd = new Random();
            this.datacenterId = rnd.nextInt(1023) + 1;
        }
        System.out.printf("SNOWFLAKE: initialised with datacenter ID {}", this.datacenterId);
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    protected long getDatacenterId() throws SocketException, UnknownHostException {
        NetworkInterface network = null;
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface nint = en.nextElement();
            if (nint.isLoopback() || nint.getHardwareAddress() == null) continue;
            network = nint;
            break;
        }
        byte[] mac = network.getHardwareAddress();
        Random rnd = new Random();
        byte rndByte = (byte)(rnd.nextInt() & 0xFF);
        return (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)rndByte << 8) >> 6;
    }

    @Override
    public synchronized long getId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            System.out.printf("Clock moved backwards. Refusing to generate id for {} milliseconds.", this.lastTimestamp - timestamp);
            try {
                Thread.sleep(this.lastTimestamp - timestamp);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - 1288834974657L << 22 | this.datacenterId << 12 | this.sequence;
        if (id < 0L) {
            System.out.printf("ID is smaller than 0: {}", id);
        }
        return id;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public synchronized String getIdStr() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            System.out.printf("Clock moved backwards. Refusing to generate id for {} milliseconds.", this.lastTimestamp - timestamp);
            try {
                Thread.sleep(this.lastTimestamp - timestamp);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long id = timestamp - 1288834974657L << 22 | this.datacenterId << 12 | this.sequence;
        if (id < 0L) {
            System.out.printf("ID is smaller than 0: {}", id);
        }
        return Long.toString(id);
    }
}

