/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli;

import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.Client;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;

public final class CliUtil {
    private CliUtil() {
    }

    public static Resource sanitize(Resource resource) {
        File file;
        if (resource instanceof FileResource && (file = ((FileResource)resource).getFile()).getPath().startsWith("~/")) {
            return new FileResource(System.getProperty("user.home") + file.getPath().substring(1));
        }
        return resource;
    }

    public static boolean isPortListening(String hostname, int port) {
        boolean bl;
        ServerSocket serverSocket = new ServerSocket();
        try {
            serverSocket.setReuseAddress(false);
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(hostname), port), 1);
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return true;
            }
        }
        serverSocket.close();
        return bl;
    }

    public static String fromCommand(String ... command) {
        String result = null;
        try {
            Process process = new ProcessBuilder(command).start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                result = reader.readLine();
            }
            process.destroy();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static void execProcess(HyperfoilCommandInvocation invocation, boolean expectNewWindow, String command, String ... params) throws IOException {
        Process process = null;
        try {
            if (expectNewWindow) {
                invocation.println("Press Ctrl+C when done...");
            }
            ArrayList<String> cmdline = new ArrayList<String>();
            cmdline.addAll(Arrays.asList(command.split("[\t \n]+", 0)));
            cmdline.addAll(Arrays.asList(params));
            process = new ProcessBuilder(cmdline.toArray(new String[0])).inheritIO().start();
            process.waitFor();
        }
        catch (InterruptedException e) {
            process.destroy();
        }
    }

    public static Map<String, Stream<Map.Entry<String, Client.MinMax>>> toMapOfStreams(Map<String, Map<String, Client.MinMax>> stats) {
        return stats.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, CliUtil::sortedEntries, CliUtil.throwingMerger(), TreeMap::new));
    }

    private static Stream<Map.Entry<String, Client.MinMax>> sortedEntries(Map.Entry<String, Map<String, Client.MinMax>> e) {
        return e.getValue().entrySet().stream().sorted(Map.Entry.comparingByKey());
    }

    private static BinaryOperator<Stream<Map.Entry<String, Client.MinMax>>> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException();
        };
    }
}

