/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli;

import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.impl.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.aesh.terminal.utils.ANSI;

public class Table<T> {
    private boolean boldHeader = true;
    private Function<T, String> rowPrefix;
    private Function<T, String> rowSuffix;
    private final List<String> titles;
    private final List<Function<T, String>> functions;
    private final List<Align> aligns;
    private int idColumns = 1;

    public Table() {
        this.titles = new ArrayList<String>();
        this.functions = new ArrayList<Function<T, String>>();
        this.aligns = new ArrayList<Align>();
    }

    public Table(Table<T> other) {
        this.boldHeader = other.boldHeader;
        this.idColumns = other.idColumns;
        this.rowPrefix = other.rowPrefix;
        this.rowSuffix = other.rowSuffix;
        this.titles = new ArrayList<String>(other.titles);
        this.functions = new ArrayList<Function<T, String>>(other.functions);
        this.aligns = new ArrayList<Align>(other.aligns);
    }

    public Table<T> boldHeader(boolean boldHeader) {
        this.boldHeader = boldHeader;
        return this;
    }

    public Table<T> idColumns(int columns) {
        this.idColumns = columns;
        return this;
    }

    public Table<T> rowPrefix(Function<T, String> rowPrefix) {
        if (this.rowPrefix != null) {
            throw new IllegalStateException("Row prefix already set.");
        }
        this.rowPrefix = rowPrefix;
        return this;
    }

    public Table<T> rowSuffix(Function<T, String> rowSuffix) {
        if (this.rowSuffix != null) {
            throw new IllegalStateException("Row suffix already set.");
        }
        this.rowSuffix = rowSuffix;
        return this;
    }

    public Table<T> column(String title, Function<T, String> func) {
        return this.column(title, func, Align.LEFT);
    }

    public Table<T> columnInt(String title, Function<T, Integer> func) {
        return this.column(title, value -> String.valueOf(func.apply(value)), Align.RIGHT);
    }

    public Table<T> columnLong(String title, Function<T, Long> func) {
        return this.column(title, value -> String.valueOf(func.apply(value)), Align.RIGHT);
    }

    public Table<T> columnNanos(String title, Function<T, Long> func) {
        return this.column(title, value -> Util.prettyPrintNanos((long)((Long)func.apply(value))), Align.RIGHT);
    }

    public Table<T> column(String title, Function<T, String> func, Align align) {
        this.titles.add(title);
        this.functions.add(func);
        this.aligns.add(align);
        return this;
    }

    public int print(HyperfoilCommandInvocation invocation, String keyTitle, Map<String, Stream<T>> map) {
        ArrayList<String> titles = new ArrayList<String>();
        titles.add(keyTitle);
        titles.addAll(this.titles);
        ArrayList<Align> aligns = new ArrayList<Align>();
        aligns.add(Align.LEFT);
        aligns.addAll(this.aligns);
        ArrayList<String> prefixes = this.rowPrefix == null ? null : new ArrayList<String>();
        ArrayList<String> suffixes = this.rowSuffix == null ? null : new ArrayList<String>();
        ArrayList<String[]> values = new ArrayList<String[]>();
        int[] width = titles.stream().mapToInt(Table::width).toArray();
        map.forEach((key, value) -> {
            AtomicBoolean first = new AtomicBoolean(true);
            value.forEach(item -> {
                if (this.rowPrefix != null && prefixes != null) {
                    prefixes.add(this.rowPrefix.apply(item));
                }
                if (this.rowSuffix != null && suffixes != null) {
                    suffixes.add(this.rowSuffix.apply(item));
                }
                String[] row = new String[this.functions.size() + 1];
                row[0] = first.compareAndSet(true, false) ? key : "";
                width[0] = Math.max(width[0], Table.width(key));
                for (int i = 1; i < row.length; ++i) {
                    row[i] = this.functions.get(i - 1).apply(item);
                    if (row[i] == null) {
                        row[i] = "";
                    }
                    width[i] = Math.max(width[i], Table.width(row[i]));
                }
                values.add(row);
            });
        });
        return this.print(invocation, titles, prefixes, values, suffixes, aligns, width);
    }

    public int print(HyperfoilCommandInvocation invocation, Stream<T> stream) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        ArrayList<String> prefixes = this.rowPrefix == null ? null : new ArrayList<String>();
        ArrayList<String> suffixes = this.rowSuffix == null ? null : new ArrayList<String>();
        int[] width = this.titles.stream().mapToInt(Table::width).toArray();
        stream.forEach(item -> {
            if (this.rowPrefix != null && prefixes != null) {
                prefixes.add(this.rowPrefix.apply(item));
            }
            if (this.rowSuffix != null && suffixes != null) {
                suffixes.add(this.rowSuffix.apply(item));
            }
            String[] row = new String[this.functions.size()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.functions.get(i).apply(item);
                if (row[i] == null) {
                    row[i] = "";
                }
                width[i] = Math.max(width[i], Table.width(row[i]));
            }
            values.add(row);
        });
        return this.print(invocation, this.titles, prefixes, values, suffixes, this.aligns, width);
    }

    private static int width(String str) {
        int width = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '\u001b') {
                char c;
                ++i;
                while (!(i >= str.length() || (c = str.charAt(i)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
                    ++i;
                }
                continue;
            }
            ++width;
        }
        return width;
    }

    private int print(HyperfoilCommandInvocation invocation, List<String> titles, List<String> prefixes, List<String[]> values, List<String> suffixes, List<Align> aligns, int[] width) {
        int i;
        StringBuilder sb = new StringBuilder();
        int lines = 0;
        int prefixLength = prefixes == null ? 0 : prefixes.stream().filter(Objects::nonNull).mapToInt(Table::width).max().orElse(0);
        int suffixLength = prefixes == null ? 0 : prefixes.stream().filter(Objects::nonNull).mapToInt(Table::width).max().orElse(0);
        int totalWidth = IntStream.of(width).map(w -> w + 2).sum() - 2;
        int maxWidth = invocation.getShell().size().getWidth() - prefixLength - suffixLength;
        boolean multiline = totalWidth > maxWidth;
        int idsWidth = IntStream.of(width).limit(this.idColumns).map(w -> w + 2).sum();
        int stride = width.length - this.idColumns;
        if (multiline) {
            int[] newWidth = Arrays.copyOf(width, width.length);
            do {
                int currentStride = stride;
                for (int i2 = this.idColumns; i2 < this.idColumns + stride; ++i2) {
                    newWidth[i2] = IntStream.iterate(i2, x -> x < width.length, x -> x + currentStride).map(j -> width[j]).max().orElse(width[i2]);
                }
                int lineWidth = idsWidth + IntStream.of(newWidth).skip(this.idColumns).limit(stride).map(w -> w + 2).sum() - 2;
                if (lineWidth <= maxWidth) break;
                System.arraycopy(width, this.idColumns, newWidth, this.idColumns, width.length - this.idColumns);
            } while (--stride > 1);
            System.arraycopy(newWidth, this.idColumns, width, this.idColumns, stride);
            for (int i3 = this.idColumns + stride; i3 < width.length; ++i3) {
                width[i3] = width[i3 - stride];
            }
        }
        if (this.boldHeader) {
            sb.append(ANSI.BOLD);
        }
        for (i = 0; i < this.idColumns; ++i) {
            String title = titles.get(i);
            sb.append(title);
            Table.pad(sb, width[i] - Table.width(title) + 2, ' ');
        }
        for (i = this.idColumns; i < width.length; i += stride) {
            for (int j2 = 0; j2 < stride - 1 && i + j2 < width.length; ++j2) {
                String title = titles.get(i + j2);
                sb.append(title);
                Table.pad(sb, width[i + j2] - Table.width(title) + 2, ' ');
            }
            if (i + stride - 1 < width.length) {
                sb.append(titles.get(i + stride - 1));
            }
            if (i + stride >= width.length) continue;
            if (this.boldHeader) {
                sb.append("\u001b[0m");
            }
            sb.append('\n');
            if (this.boldHeader) {
                sb.append(ANSI.BOLD);
            }
            Table.pad(sb, idsWidth, ' ');
            ++lines;
        }
        if (this.boldHeader) {
            sb.append("\u001b[0m");
        }
        if (multiline) {
            sb.append('\n');
            Table.pad(sb, maxWidth, '-');
            ++lines;
        }
        sb.append('\n');
        ++lines;
        int rowNumber = 0;
        for (String[] row : values) {
            int i4;
            String suffix;
            String prefix = prefixes == null ? null : prefixes.get(rowNumber);
            String string = suffix = suffixes == null ? null : suffixes.get(rowNumber);
            if (prefix != null) {
                sb.append(prefix);
                Table.pad(sb, prefixLength - Table.width(prefix), ' ');
            }
            for (i4 = 0; i4 < this.idColumns; ++i4) {
                this.printAligned(sb, row, width, aligns, i4);
                sb.append("  ");
            }
            for (i4 = this.idColumns; i4 < width.length; i4 += stride) {
                for (int j3 = 0; j3 < stride - 1 && i4 + j3 < width.length; ++j3) {
                    this.printAligned(sb, row, width, aligns, i4 + j3);
                    sb.append("  ");
                }
                if (i4 + stride - 1 < width.length) {
                    this.printAligned(sb, row, width, aligns, i4 + stride - 1);
                }
                if (i4 + stride >= width.length) continue;
                if (suffix != null) {
                    sb.append(suffix);
                    Table.pad(sb, suffixLength - Table.width(suffix), ' ');
                }
                sb.append('\n');
                if (prefix != null) {
                    sb.append(prefix);
                    Table.pad(sb, prefixLength - Table.width(prefix), ' ');
                }
                Table.pad(sb, idsWidth, ' ');
                ++lines;
            }
            if (suffix != null) {
                sb.append(suffix);
                Table.pad(sb, suffixLength - Table.width(suffix), ' ');
            }
            if (multiline) {
                sb.append('\n');
                Table.pad(sb, maxWidth, '-');
                ++lines;
            }
            sb.append('\n');
            ++rowNumber;
            ++lines;
        }
        invocation.print(sb.toString());
        return lines;
    }

    private void printAligned(StringBuilder sb, String[] row, int[] width, List<Align> aligns, int i) {
        Align align = aligns.get(i);
        if (align == Align.RIGHT) {
            Table.pad(sb, width[i] - Table.width(row[i]), ' ');
        }
        sb.append(row[i]);
        if (align == Align.LEFT) {
            Table.pad(sb, width[i] - Table.width(row[i]), ' ');
        }
    }

    private static void pad(StringBuilder sb, int n, char c) {
        for (int i = 0; i < n; ++i) {
            sb.append(c);
        }
    }

    public static enum Align {
        LEFT,
        RIGHT;

    }
}

