/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.HostCompleter;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.readline.Prompt;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.readline.terminal.formatting.TerminalString;

@CommandDefinition(name="connect", description="Connects CLI to Hyperfoil Controller server")
public class Connect
extends ServerCommand {
    private static final int DEFAULT_PORT = 8090;
    @Argument(description="Hyperfoil host", completer=HostCompleter.class)
    String host;
    @Option(shortName=112, description="Hyperfoil port")
    Integer port;
    @Option(shortName=116, description="Use secure (HTTPS/TLS) connections.", hasValue=false)
    boolean tls;
    @Option(name="no-tls", description="Do not use (HTTPS/TLS) connections.", hasValue=false)
    boolean noTls;
    @Option(shortName=107, description="Do not verify certificate validity.", hasValue=false)
    boolean insecure;
    @Option(description="Password used for server access (will be queried if necessary).")
    String password;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        int colonIndex;
        int end;
        HyperfoilCliContext ctx = invocation.context();
        if (this.host != null && this.host.startsWith("http://")) {
            end = this.host.indexOf(47, 7);
            this.host = this.host.substring(7, end < 0 ? this.host.length() : end);
            if (this.port == null) {
                this.port = 80;
            }
        } else if (this.host != null && this.host.startsWith("https://")) {
            end = this.host.indexOf(47, 8);
            this.host = this.host.substring(8, end < 0 ? this.host.length() : end);
            if (this.port == null) {
                this.port = 443;
            }
            if (!this.noTls) {
                this.tls = true;
            }
        }
        if (this.host != null && (colonIndex = this.host.indexOf(58)) >= 0) {
            String portStr = this.host.substring(colonIndex + 1);
            try {
                this.port = Integer.parseInt(portStr);
                this.host = this.host.substring(0, colonIndex);
            }
            catch (NumberFormatException e) {
                invocation.error("Cannot parse port '" + portStr + "'");
                return CommandResult.FAILURE;
            }
        }
        if (this.port != null && this.port % 1000 == 443 && !this.noTls) {
            this.tls = true;
        }
        if (ctx.client() != null) {
            if (ctx.client().host().equals(this.host) && (ctx.client().port() == 8090 && this.port == null || this.port != null && ctx.client().port() == this.port.intValue())) {
                invocation.println("Already connected to " + ctx.client().host() + ":" + ctx.client().port() + ", not reconnecting.");
                return CommandResult.SUCCESS;
            }
            invocation.println("Closing connection to " + ctx.client());
            ctx.client().close();
            ctx.setClient(null);
            ctx.setServerRun(null);
            ctx.setServerBenchmark(null);
            ctx.setOnline(false);
            invocation.setPrompt(new Prompt(new TerminalString("[hyperfoil]$ ", new TerminalColor(Color.GREEN, Color.DEFAULT, Color.Intensity.BRIGHT))));
        }
        if (this.host == null && this.port == null && invocation.context().localControllerPort() > 0) {
            this.host = invocation.context().localControllerHost();
            this.port = invocation.context().localControllerPort();
        } else if (this.host == null) {
            this.host = "localhost";
        }
        if (this.port == null) {
            this.port = 8090;
        }
        this.connect(invocation, false, this.host, this.port, this.tls, this.insecure, this.password);
        return CommandResult.SUCCESS;
    }
}

