/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Run;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="connections", aliases={"conns"}, description="Shows number and type of connections.")
public class Connections
extends BaseRunIdCommand {
    Table<Map.Entry<String, Client.MinMax>> CONNECTION_STATS = new Table<Map.Entry>().column("TYPE", Map.Entry::getKey).column("MIN", e -> String.valueOf(((Client.MinMax)e.getValue()).min), Table.Align.RIGHT).column("MAX", e -> String.valueOf(((Client.MinMax)e.getValue()).max), Table.Align.RIGHT);
    @Option(description="Show overall stats for the run.")
    boolean total;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        Client.RunRef runRef = this.getRunRef(invocation);
        Map connectionStats = null;
        try {
            do {
                if (!this.total) {
                    int numLines = connectionStats == null ? 0 : connectionStats.values().stream().mapToInt(Map::size).sum() + 2;
                    connectionStats = runRef.connectionStatsRecent();
                    this.clearLines(invocation, numLines);
                }
                if (connectionStats == null || connectionStats.isEmpty()) {
                    Run run = runRef.get();
                    if (this.total || run.terminated != null) {
                        invocation.println("Run " + run.id + " has terminated.");
                        this.CONNECTION_STATS.print(invocation, "TARGET", CliUtil.toMapOfStreams(runRef.connectionStatsTotal()));
                        return CommandResult.SUCCESS;
                    }
                }
                if (connectionStats == null) continue;
                this.CONNECTION_STATS.print(invocation, "TARGET", CliUtil.toMapOfStreams(connectionStats));
            } while (!this.interruptibleDelay(invocation));
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            if (e.getCause() instanceof InterruptedException) {
                this.clearLines(invocation, 1);
                invocation.println("");
                return CommandResult.SUCCESS;
            }
            invocation.error(e);
            throw new CommandException("Cannot display connection stats.", (Throwable)e);
        }
    }
}

