/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.ParamsCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="inspect", description="Show detailed structure of the benchmark.")
public class Inspect
extends ParamsCommand {
    @Option(name="pager", shortName=112, description="Pager used.")
    private String pager;
    @Option(name="max-collection-size", shortName=109, description="Maximum printed size for collections and arrays.")
    private Integer maxCollectionSize;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        Client.BenchmarkStructure structure;
        Client.BenchmarkRef benchmarkRef;
        this.ensureConnection(invocation);
        try {
            benchmarkRef = this.ensureBenchmark(invocation);
            structure = benchmarkRef.structure(this.maxCollectionSize, Collections.emptyMap());
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot get benchmark " + this.benchmark);
        }
        if (structure.params != null && !structure.params.isEmpty()) {
            invocation.println("Benchmark template '" + benchmarkRef.name() + "' has these parameters and default values:\n");
            this.printTemplateParams(invocation, structure.params);
            invocation.print("Do you want to display structure with a resolved template? [y/N]: ");
            if (this.readYes(invocation)) {
                Map<String, String> currentParams = this.getParams(invocation);
                List<String> missingParams = this.getMissingParams(structure.params, currentParams);
                if (!this.readParams(invocation, missingParams, currentParams)) {
                    return CommandResult.FAILURE;
                }
                try {
                    structure = benchmarkRef.structure(this.maxCollectionSize, currentParams);
                }
                catch (RestClientException e) {
                    invocation.error(e);
                    throw new CommandException("Cannot get benchmark " + this.benchmark);
                }
                invocation.context().setCurrentParams(currentParams);
            }
        }
        if (structure.content != null) {
            invocation.context().createPager(this.pager).open(invocation, structure.content, this.benchmark + "-structure-", ".yaml");
        }
        return CommandResult.SUCCESS;
    }
}

