/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.Run;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;

@CommandDefinition(name="kill", description="Terminate run.")
public class Kill
extends BaseRunIdCommand {
    @Option(shortName=121, description="Assume yes for all interactive questions.", hasValue=false)
    public boolean assumeYes;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException, InterruptedException {
        Client.RunRef runRef = this.getRunRef(invocation);
        Run run = runRef.get();
        if (!this.assumeYes) {
            invocation.print("Kill run " + run.id + ", benchmark " + run.benchmark);
            int terminated = 0;
            int finished = 0;
            int running = 0;
            for (Phase phase : run.phases) {
                if ("TERMINATED".equals(phase.status)) {
                    ++terminated;
                    continue;
                }
                if ("FINISHED".equals(phase.status)) {
                    ++finished;
                    continue;
                }
                if (!"RUNNING".equals(phase.status)) continue;
                ++running;
            }
            invocation.print("(phases: " + running + " running, " + finished + " finished, " + terminated + " terminated) [y/N]: ");
            if (!this.readYes(invocation)) {
                invocation.println("Kill cancelled.");
                return CommandResult.SUCCESS;
            }
        }
        try {
            runRef.kill();
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to kill run " + run.id, (Throwable)e);
        }
        invocation.println("Killed.");
        return CommandResult.SUCCESS;
    }
}

