/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.controller.model.Run;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.terminal.utils.ANSI;

@CommandDefinition(name="runs", description="Print info about past runs.")
public class Runs
extends ServerCommand {
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Table<Run> RUN_TABLE = new Table().idColumns(2).column("", run -> Runs.runIcon(run)).column("RUN_ID", run -> run.id).column("BENCHMARK", run -> run.benchmark).column("STARTED", run -> run.started == null ? "" : DATE_FORMATTER.format(run.started)).column("TERMINATED", run -> run.terminated == null ? "" : DATE_FORMATTER.format(run.terminated)).column("DESCRIPTION", run -> run.description);

    private static String runIcon(Run run) {
        if (run.cancelled) {
            return "\u001b[0;31m\u00d7\u001b[0m";
        }
        if (run.errors != null && !run.errors.isEmpty()) {
            return "\u001b[0;31m" + (run.terminated == null ? ANSI.BLINK : "") + "!\u001b[0m";
        }
        if (run.started == null) {
            return "\u001b[0;33m?\u001b[0m";
        }
        if (run.terminated == null) {
            return "\u001b[0;33m" + ANSI.BLINK + "?\u001b[0m";
        }
        return "\u001b[0;32m+\u001b[0m";
    }

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        this.ensureConnection(invocation);
        List<Run> runs = invocation.context().client().runs(true);
        RUN_TABLE.print(invocation, runs.stream().sorted(Comparator.comparing(run -> run.id)));
        return CommandResult.SUCCESS;
    }
}

