/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.ServerCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.internal.Controller;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;

@CommandDefinition(name="start-local", description="Start non-clustered controller within the CLI process.")
public class StartLocal
extends ServerCommand {
    @Option(shortName=108, description="Default log level for controller log.", defaultValue={""})
    private String logLevel;
    @Option(shortName=113, description="Do not print anything on output in this command.", hasValue=false)
    private boolean quiet;
    @Argument(description="Root directory used for the controller.")
    private Resource rootDir;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        HyperfoilCliContext ctx = invocation.context();
        if (ctx.localControllerHost() != null || ctx.localControllerPort() > 0) {
            if (!this.quiet) {
                invocation.warn("Local controller is already running, not starting.");
            }
        } else {
            Controller.Factory factory = null;
            Iterator<Controller.Factory> iterator = ServiceLoader.load(Controller.Factory.class).iterator();
            if (iterator.hasNext()) {
                Controller.Factory f;
                factory = f = iterator.next();
            }
            if (factory == null) {
                throw new CommandException("Controller is not on the classpath, cannot start.");
            }
            this.rootDir = CliUtil.sanitize(this.rootDir);
            if (!(this.rootDir == null || !this.rootDir.exists() || this.rootDir.isDirectory() && this.rootDir instanceof FileResource)) {
                if (!this.quiet) {
                    invocation.println("You are trying to start Hyperfoil controller with root dir " + this.rootDir);
                }
                throw new CommandException(this.rootDir + " exists but it is not a directory");
            }
            if (!this.quiet) {
                invocation.println("Starting controller in " + (this.rootDir == null ? "default directory (/tmp/hyperfoil)" : this.rootDir.getAbsolutePath()));
            }
            if (!this.logLevel.isEmpty()) {
                System.setProperty("io.hyperfoil.controller.log.level", this.logLevel);
            }
            this.reconfigureLogging(invocation);
            Controller controller = factory.start(this.rootDir == null ? null : ((FileResource)this.rootDir).getFile().toPath());
            ctx.setLocalControllerHost(controller.host());
            ctx.setLocalControllerPort(controller.port());
            if (!this.quiet) {
                invocation.println("Controller started, listening on " + controller.host() + ":" + controller.port());
            }
            ctx.addCleanup(() -> ((Controller)controller).stop());
        }
        if (!this.quiet) {
            invocation.println("Connecting to the controller...");
        }
        if (ctx.client() != null) {
            ctx.client().close();
        }
        this.connect(invocation, this.quiet, ctx.localControllerHost(), ctx.localControllerPort(), false, false, null);
        return CommandResult.SUCCESS;
    }

    private void reconfigureLogging(HyperfoilCommandInvocation invocation) {
        try {
            LoggerContext context = ((Logger)LogManager.getLogger(this.getClass())).getContext();
            InputStream configStream = this.getClass().getClassLoader().getResourceAsStream("log4j2-local-controller.xml");
            context.setConfiguration((Configuration)new XmlConfiguration(context, new ConfigurationSource(configStream)));
        }
        catch (IOException e) {
            invocation.error("Failed to set logger configuration");
            invocation.error(e);
        }
    }
}

