/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.cli.Table;
import io.hyperfoil.cli.commands.BaseRunIdCommand;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Phase;
import io.hyperfoil.controller.model.Run;
import java.text.SimpleDateFormat;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.aesh.terminal.utils.ANSI;

@CommandDefinition(name="status", description="Prints information about executing or completed run.")
public class Status
extends BaseRunIdCommand {
    private static final int MAX_ERRORS = 15;
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Table<Phase> PHASE_TABLE = new Table<Phase>().column("NAME", p -> p.name).column("STATUS", p -> p.status).column("STARTED", p -> p.started == null ? null : TIME_FORMATTER.format(p.started)).column("REMAINING", p -> p.remaining, Table.Align.RIGHT).column("COMPLETED", p -> p.completed == null ? null : TIME_FORMATTER.format(p.completed)).column("TOTAL DURATION", p -> p.totalDuration).column("DESCRIPTION", p -> p.description);
    @Option(name="all", shortName=97, description="Show all phases", hasValue=false)
    boolean all;
    @Option(name="no-errors", shortName=69, description="Do not list errors", hasValue=false)
    boolean noErrors;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        Run run;
        Client.RunRef runRef = this.getRunRef(invocation);
        try {
            run = runRef.get();
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Cannot fetch status for run " + runRef.id(), (Throwable)e);
        }
        invocation.println("Run " + run.id + ", benchmark " + run.benchmark);
        if (run.description != null) {
            invocation.println(run.description);
        }
        while (true) {
            int lines = 0;
            if (run.agents != null && !run.agents.isEmpty()) {
                invocation.print("Agents: ");
                invocation.println(String.join((CharSequence)", ", (CharSequence[])run.agents.stream().map(a -> a.name + "[" + a.status + "]").toArray(String[]::new)));
                ++lines;
            }
            if (run.started != null) {
                invocation.print("Started: " + DATE_FORMATTER.format(run.started) + "    ");
            }
            if (run.terminated != null) {
                invocation.println("Terminated: " + DATE_FORMATTER.format(run.terminated));
            } else {
                invocation.println("");
            }
            ++lines;
            Run r = run;
            lines += PHASE_TABLE.print(invocation, run.phases.stream().filter(p -> this.showPhase(r, (Phase)p)));
            long cancelled = run.phases.stream().filter(p -> "CANCELLED".equals(p.status)).count();
            if (cancelled > 0L) {
                invocation.println(cancelled + " phases were cancelled.");
                ++lines;
            }
            if (!run.errors.isEmpty() && !this.noErrors) {
                invocation.println("\u001b[0;31m" + ANSI.BOLD + "Errors:\u001b[0m");
                ++lines;
                for (int i = 0; i < run.errors.size() && (this.all || i < 15); ++i) {
                    invocation.println((String)run.errors.get(run.errors.size() - 1 - i));
                    ++lines;
                }
                if (run.errors.size() > 15 && !this.all) {
                    invocation.println("... " + (run.errors.size() - 15) + " more errors ...");
                    ++lines;
                }
            }
            if (run.terminated != null) {
                invocation.context().notifyRunCompleted(run);
                return CommandResult.SUCCESS;
            }
            if (this.interruptibleDelay(invocation)) {
                return CommandResult.SUCCESS;
            }
            ++lines;
            try {
                run = runRef.get();
            }
            catch (RestClientException e) {
                if (e.getCause() instanceof InterruptedException) {
                    this.clearLines(invocation, 1);
                    invocation.println("");
                    return CommandResult.SUCCESS;
                }
                invocation.error(e);
                throw new CommandException("Cannot fetch status for run " + runRef.id(), (Throwable)e);
            }
            this.clearLines(invocation, lines);
        }
    }

    private boolean showPhase(Run run, Phase phase) {
        return (this.all || run.terminated != null) && !"CANCELLED".equals(phase.status) || "RUNNING".equals(phase.status) || "FINISHED".equals(phase.status);
    }
}

