/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.cli.commands;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.cli.CliUtil;
import io.hyperfoil.cli.commands.BaseUploadCommand;
import io.hyperfoil.cli.context.HyperfoilCliContext;
import io.hyperfoil.cli.context.HyperfoilCommandInvocation;
import io.hyperfoil.client.RestClientException;
import io.hyperfoil.controller.Client;
import io.hyperfoil.core.impl.LocalBenchmarkData;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Argument;
import org.aesh.io.Resource;

@CommandDefinition(name="upload", description="Uploads benchmark definition to Hyperfoil Controller server")
public class Upload
extends BaseUploadCommand {
    @Argument(description="YAML benchmark definition file", required=true)
    Resource benchmarkResource;

    public CommandResult execute(HyperfoilCommandInvocation invocation) throws CommandException {
        String benchmarkYaml;
        this.ensureConnection(invocation);
        HyperfoilCliContext ctx = invocation.context();
        Resource sanitizedResource = CliUtil.sanitize(this.benchmarkResource);
        try {
            benchmarkYaml = Util.toString((InputStream)sanitizedResource.read());
        }
        catch (IOException e) {
            this.logError(invocation, e);
            throw new CommandException("Failed to load the benchmark.", (Throwable)e);
        }
        LocalBenchmarkData data = new LocalBenchmarkData(Paths.get(sanitizedResource.getAbsolutePath(), new String[0]));
        if (this.extraFiles != null) {
            for (String extraFile : this.extraFiles) {
                try {
                    InputStream ignored = data.readFile(extraFile);
                    if (ignored == null) continue;
                    ignored.close();
                }
                catch (IOException e) {
                    invocation.error("Cannot read file " + extraFile, e);
                    return CommandResult.FAILURE;
                }
            }
        }
        try {
            BenchmarkSource source = this.loadBenchmarkSource(invocation, benchmarkYaml, (BenchmarkData)data);
            Path benchmarkDir = Paths.get(sanitizedResource.getAbsolutePath(), new String[0]).getParent();
            Map<String, Path> extraFiles = source.data.files().keySet().stream().collect(Collectors.toMap(file -> file, file -> {
                Path path = Paths.get(file, new String[0]);
                return path.isAbsolute() ? path : benchmarkDir.resolve((String)file);
            }));
            Client.BenchmarkRef benchmarkRef = ctx.client().register(Paths.get(sanitizedResource.getAbsolutePath(), new String[0]), extraFiles, null, null);
            ctx.setServerBenchmark(benchmarkRef);
            invocation.println("... done.");
            return CommandResult.SUCCESS;
        }
        catch (RestClientException e) {
            invocation.error(e);
            throw new CommandException("Failed to upload the benchmark.", (Throwable)e);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            this.logError(invocation, e);
            throw new CommandException("Unknown error.", (Throwable)e);
        }
    }
}

