/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.client.RestClient;
import io.hyperfoil.controller.Client;
import io.hyperfoil.controller.model.Histogram;
import io.hyperfoil.controller.model.RequestStatisticsResponse;
import io.hyperfoil.controller.model.Run;
import io.hyperfoil.impl.Util;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.Json;
import io.vertx.core.json.jackson.JacksonCodec;
import io.vertx.ext.web.client.HttpResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class RunRefImpl
implements Client.RunRef {
    private final RestClient client;
    private final String id;

    public RunRefImpl(RestClient client, String id) {
        this.client = client;
        int lastSlash = id.lastIndexOf(47);
        this.id = lastSlash >= 0 ? id.substring(lastSlash + 1) : id;
    }

    public String id() {
        return this.id;
    }

    public Run get() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id).send(handler), 200, response -> (Run)Json.decodeValue((Buffer)((Buffer)response.body()), Run.class));
    }

    public Client.RunRef kill() {
        this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/kill").send(handler), 202, response -> null);
        return this;
    }

    public Benchmark benchmark() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/benchmark").putHeader(HttpHeaders.ACCEPT.toString(), "application/java-serialized-object").send(handler), 200, response -> {
            try {
                return Util.deserialize((byte[])response.bodyAsBuffer().getBytes());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CompletionException(e);
            }
        });
    }

    public Map<String, Map<String, Client.MinMax>> sessionStatsRecent() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/sessions/recent").send(handler), 200, response -> (Map)JacksonCodec.decodeValue((Buffer)((Buffer)response.body()), (TypeReference)new TypeReference<Map<String, Map<String, Client.MinMax>>>(){}));
    }

    public Map<String, Map<String, Client.MinMax>> sessionStatsTotal() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/sessions/total").send(handler), 200, response -> (Map)JacksonCodec.decodeValue((Buffer)((Buffer)response.body()), (TypeReference)new TypeReference<Map<String, Map<String, Client.MinMax>>>(){}));
    }

    public Collection<String> sessions() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/sessions").send(handler), 200, response -> Arrays.asList(response.bodyAsString().split("\n")));
    }

    public Collection<String> connections() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/connections").send(handler), 200, response -> Arrays.asList(response.bodyAsString().split("\n")));
    }

    public Map<String, Map<String, Client.MinMax>> connectionStatsRecent() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/connections/recent").send(handler), 200, response -> (Map)JacksonCodec.decodeValue((Buffer)((Buffer)response.body()), (TypeReference)new TypeReference<Map<String, Map<String, Client.MinMax>>>(){}));
    }

    public Map<String, Map<String, Client.MinMax>> connectionStatsTotal() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/connections/total").send(handler), 200, response -> (Map)JacksonCodec.decodeValue((Buffer)((Buffer)response.body()), (TypeReference)new TypeReference<Map<String, Map<String, Client.MinMax>>>(){}));
    }

    public RequestStatisticsResponse statsRecent() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/stats/recent").putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send(handler), 200, response -> (RequestStatisticsResponse)Json.decodeValue((Buffer)((Buffer)response.body()), RequestStatisticsResponse.class));
    }

    public RequestStatisticsResponse statsTotal() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/stats/total").putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send(handler), 200, response -> (RequestStatisticsResponse)Json.decodeValue((Buffer)((Buffer)response.body()), RequestStatisticsResponse.class));
    }

    public byte[] statsAll(String format) {
        CompletableFuture future = new CompletableFuture();
        this.client.vertx.runOnContext(ctx -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/stats/all").putHeader(HttpHeaders.ACCEPT.toString(), format).send(rsp -> {
            if (rsp.failed()) {
                future.completeExceptionally(rsp.cause());
                return;
            }
            HttpResponse response = (HttpResponse)rsp.result();
            if (response.statusCode() != 200) {
                future.completeExceptionally(RestClient.unexpected((HttpResponse<Buffer>)response));
                return;
            }
            try {
                future.complete(((Buffer)response.body()).getBytes());
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        }));
        return (byte[])RestClient.waitFor(future);
    }

    public Histogram histogram(String phase, int stepId, String metric) {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/stats/histogram").addQueryParam("phase", phase).addQueryParam("stepId", String.valueOf(stepId)).addQueryParam("metric", metric).putHeader(HttpHeaders.ACCEPT.toString(), "application/json").send(handler), 200, response -> (Histogram)Json.decodeValue((Buffer)((Buffer)response.body()), Histogram.class));
    }

    public byte[] file(String filename) {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/file").addQueryParam("file", filename).send(handler), 200, response -> ((Buffer)response.body()).getBytes());
    }

    public byte[] report(String source) {
        String path = "/run/" + this.id + "/report" + (String)(source != null && !source.isEmpty() ? "?source=" + source : "");
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, path).send(handler), 200, response -> ((Buffer)response.body()).getBytes());
    }

    public Map<String, Map<String, String>> agentCpu() {
        return this.client.sync(handler -> this.client.request(HttpMethod.GET, "/run/" + this.id + "/agentCpu").send(handler), 200, response -> (Map)JacksonCodec.decodeValue((Buffer)((Buffer)response.body()), (TypeReference)new TypeReference<Map<String, Map<String, String>>>(){}));
    }
}

