/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.apt;

import io.jooby.annotations.CONNECT;
import io.jooby.annotations.Consumes;
import io.jooby.annotations.ContextParam;
import io.jooby.annotations.CookieParam;
import io.jooby.annotations.DELETE;
import io.jooby.annotations.FlashParam;
import io.jooby.annotations.FormParam;
import io.jooby.annotations.GET;
import io.jooby.annotations.HEAD;
import io.jooby.annotations.HeaderParam;
import io.jooby.annotations.OPTIONS;
import io.jooby.annotations.PATCH;
import io.jooby.annotations.POST;
import io.jooby.annotations.PUT;
import io.jooby.annotations.Param;
import io.jooby.annotations.Path;
import io.jooby.annotations.PathParam;
import io.jooby.annotations.Produces;
import io.jooby.annotations.QueryParam;
import io.jooby.annotations.SessionParam;
import io.jooby.annotations.TRACE;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public interface Annotations {
    public static final String JAXRS_GET = "javax.ws.rs.GET";
    public static final String JAXRS_POST = "javax.ws.rs.POST";
    public static final String JAXRS_PUT = "javax.ws.rs.PUT";
    public static final String JAXRS_DELETE = "javax.ws.rs.DELETE";
    public static final String JAXRS_PATCH = "javax.ws.rs.PATCH";
    public static final String JAXRS_HEAD = "javax.ws.rs.HEAD";
    public static final String JAXRS_OPTIONS = "javax.ws.rs.OPTIONS";
    public static final String JAXRS_CONTEXT = "javax.ws.rs.core.Context";
    public static final String JAXRS_QUERY = "javax.ws.rs.QueryParam";
    public static final String JAXRS_PATH_PARAM = "javax.ws.rs.PathParam";
    public static final String JAXRS_COOKIE = "javax.ws.rs.CookieParam";
    public static final String JAXRS_HEADER = "javax.ws.rs.HeaderParam";
    public static final String JAXRS_FORM = "javax.ws.rs.FormParam";
    public static final String JAXRS_PRODUCES = "javax.ws.rs.Produces";
    public static final String JAXRS_CONSUMES = "javax.ws.rs.Consumes";
    public static final String JAXRS_PATH = "javax.ws.rs.Path";
    public static final Set<String> HTTP_METHODS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(GET.class.getName(), "javax.ws.rs.GET", POST.class.getName(), "javax.ws.rs.POST", PUT.class.getName(), "javax.ws.rs.PUT", DELETE.class.getName(), "javax.ws.rs.DELETE", PATCH.class.getName(), "javax.ws.rs.PATCH", HEAD.class.getName(), "javax.ws.rs.HEAD", OPTIONS.class.getName(), "javax.ws.rs.OPTIONS", CONNECT.class.getName(), TRACE.class.getName())));
    public static final Set<String> PATH_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(PathParam.class.getName(), "javax.ws.rs.PathParam")));
    public static final Set<String> CONTEXT_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(ContextParam.class.getName(), "javax.ws.rs.core.Context")));
    public static final Set<String> QUERY_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(QueryParam.class.getName(), "javax.ws.rs.QueryParam")));
    public static final Set<String> SESSION_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(SessionParam.class.getName())));
    public static final Set<String> COOKIE_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(CookieParam.class.getName(), "javax.ws.rs.CookieParam")));
    public static final Set<String> HEADER_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(HeaderParam.class.getName(), "javax.ws.rs.HeaderParam")));
    public static final Set<String> FLASH_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(FlashParam.class.getName())));
    public static final Set<String> FORM_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(FormParam.class.getName(), "javax.ws.rs.FormParam")));
    public static final Set<String> PARAM_LOOKUP = Collections.unmodifiableSet(Collections.singleton(Param.class.getName()));
    public static final Set<String> PRODUCES_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(Produces.class.getName(), "javax.ws.rs.Produces")));
    public static final Set<String> CONSUMES_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(Consumes.class.getName(), "javax.ws.rs.Consumes")));
    public static final Set<String> PATH = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(Path.class.getName(), "javax.ws.rs.Path")));

    @Nonnull
    public static List<String> attribute(@Nonnull AnnotationMirror mirror, @Nonnull String name) {
        return Annotations.attribute(mirror, name, v -> v.getValue().toString());
    }

    @Nonnull
    public static <T> List<T> attribute(@Nonnull AnnotationMirror mirror, @Nonnull String name, @Nonnull Function<AnnotationValue, T> mapper) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(name)) continue;
            Object value = entry.getValue().getValue();
            if (value instanceof List) {
                List values = (List)value;
                return values.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
            }
            T singleValue = mapper.apply(entry.getValue());
            return singleValue == null ? Collections.emptyList() : Collections.singletonList(singleValue);
        }
        return Collections.emptyList();
    }
}

