/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.internal.apt.TypeDefinition;
import java.lang.reflect.Method;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class Primitives {
    public static Method wrapper(TypeDefinition type) throws NoSuchMethodException {
        return Primitives.wrapper(type.getType());
    }

    public static Method wrapper(TypeMirror type) throws NoSuchMethodException {
        return Primitives.wrapper(type.getKind());
    }

    public static Method wrapper(TypeKind type) throws NoSuchMethodException {
        return Primitives.wrapper(type.name().toLowerCase());
    }

    public static Method wrapper(Class type) throws NoSuchMethodException {
        return Primitives.wrapper(type.getSimpleName());
    }

    public static Method wrapper(String name) throws NoSuchMethodException {
        switch (name.toLowerCase()) {
            case "boolean": {
                return Boolean.class.getDeclaredMethod("valueOf", Boolean.TYPE);
            }
            case "char": 
            case "character": {
                return Character.class.getDeclaredMethod("valueOf", Character.TYPE);
            }
            case "byte": {
                return Byte.class.getDeclaredMethod("valueOf", Byte.TYPE);
            }
            case "short": {
                return Short.class.getDeclaredMethod("valueOf", Short.TYPE);
            }
            case "int": 
            case "integer": {
                return Integer.class.getDeclaredMethod("valueOf", Integer.TYPE);
            }
            case "long": {
                return Long.class.getDeclaredMethod("valueOf", Long.TYPE);
            }
            case "float": {
                return Float.class.getDeclaredMethod("valueOf", Float.TYPE);
            }
            case "double": {
                return Double.class.getDeclaredMethod("valueOf", Double.TYPE);
            }
        }
        return null;
    }

    public static Method toPrimitive(TypeDefinition type) throws NoSuchMethodException {
        return Primitives.toPrimitive(type.getType());
    }

    public static Method toPrimitive(TypeMirror type) throws NoSuchMethodException {
        return Primitives.toPrimitive(type.getKind());
    }

    public static Method toPrimitive(TypeKind type) throws NoSuchMethodException {
        return Primitives.toPrimitive(type.name().toLowerCase());
    }

    public static Method toPrimitive(String name) throws NoSuchMethodException {
        switch (name.toLowerCase()) {
            case "boolean": {
                return Boolean.class.getDeclaredMethod("booleanValue", new Class[0]);
            }
            case "character": {
                return Character.class.getDeclaredMethod("charValue", new Class[0]);
            }
            case "byte": {
                return Byte.class.getDeclaredMethod("byteValue", new Class[0]);
            }
            case "short": {
                return Short.class.getDeclaredMethod("shortValue", new Class[0]);
            }
            case "int": 
            case "integer": {
                return Integer.class.getDeclaredMethod("intValue", new Class[0]);
            }
            case "long": {
                return Long.class.getDeclaredMethod("longValue", new Class[0]);
            }
            case "float": {
                return Float.class.getDeclaredMethod("floatValue", new Class[0]);
            }
            case "double": {
                return Double.class.getDeclaredMethod("doubleValue", new Class[0]);
            }
        }
        return null;
    }
}

