/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.apt;

import io.jooby.annotations.CONNECT;
import io.jooby.annotations.Consumes;
import io.jooby.annotations.ContextParam;
import io.jooby.annotations.DELETE;
import io.jooby.annotations.FlashParam;
import io.jooby.annotations.GET;
import io.jooby.annotations.HeaderParam;
import io.jooby.annotations.OPTIONS;
import io.jooby.annotations.PATCH;
import io.jooby.annotations.PathParam;
import io.jooby.annotations.SessionParam;
import io.jooby.annotations.TRACE;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

public interface Annotations {
    public static final Set<String> HTTP_METHODS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(GET.class.getName(), javax.ws.rs.GET.class.getName(), io.jooby.annotations.POST.class.getName(), POST.class.getName(), io.jooby.annotations.PUT.class.getName(), PUT.class.getName(), DELETE.class.getName(), javax.ws.rs.DELETE.class.getName(), PATCH.class.getName(), javax.ws.rs.PATCH.class.getName(), io.jooby.annotations.HEAD.class.getName(), HEAD.class.getName(), OPTIONS.class.getName(), javax.ws.rs.OPTIONS.class.getName(), CONNECT.class.getName(), TRACE.class.getName())));
    public static final Set<String> PATH_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(PathParam.class.getName())));
    public static final Set<String> CONTEXT_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(ContextParam.class.getName(), Context.class.getName())));
    public static final Set<String> QUERY_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(io.jooby.annotations.QueryParam.class.getName(), QueryParam.class.getName())));
    public static final Set<String> SESSION_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(SessionParam.class.getName())));
    public static final Set<String> COOKIE_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(io.jooby.annotations.CookieParam.class.getName(), CookieParam.class.getName())));
    public static final Set<String> HEADER_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(HeaderParam.class.getName(), javax.ws.rs.HeaderParam.class.getName())));
    public static final Set<String> FLASH_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(FlashParam.class.getName())));
    public static final Set<String> FORM_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(io.jooby.annotations.FormParam.class.getName(), FormParam.class.getName())));
    public static final Set<String> PRODUCES_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(io.jooby.annotations.Produces.class.getName(), Produces.class.getName())));
    public static final Set<String> CONSUMES_PARAMS = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(Consumes.class.getName(), javax.ws.rs.Consumes.class.getName())));
    public static final Set<String> PATH = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(io.jooby.annotations.Path.class.getName(), Path.class.getName())));

    @Nonnull
    public static List<String> attribute(@Nonnull AnnotationMirror mirror, @Nonnull String name) {
        Function<Object, String> cleanValue = arg -> {
            if (arg instanceof AnnotationValue) {
                return ((AnnotationValue)arg).getValue().toString();
            }
            return arg.toString();
        };
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(name)) continue;
            Object value = entry.getValue().getValue();
            if (value instanceof List) {
                List values = (List)value;
                return values.stream().map(cleanValue).filter(Objects::nonNull).collect(Collectors.toList());
            }
            String singleValue = cleanValue.apply(value);
            return singleValue == null ? Collections.emptyList() : Collections.singletonList(singleValue);
        }
        return Collections.emptyList();
    }
}

