/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.internal.apt.asm.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class TypeDefinition {
    private final Types typeUtils;
    private final TypeMirror type;

    public TypeDefinition(Types types, TypeMirror type) {
        this.typeUtils = types;
        this.type = type;
    }

    public String getSimpleName() {
        String name = this.getName();
        int i = name.lastIndexOf(46);
        return i > 0 ? name.substring(i + 1) : name;
    }

    public String getName() {
        return this.getRawType().toString();
    }

    public TypeMirror getType() {
        return this.type;
    }

    public boolean isPrimitive() {
        return this.getType().getKind().isPrimitive();
    }

    public boolean isVoid() {
        return this.type.getKind() == TypeKind.VOID;
    }

    public TypeMirror getRawType() {
        return this.typeUtils.erasure(this.type);
    }

    public boolean is(Class type, Class ... arguments) {
        return this.is(this.typeName(type), (String[])Stream.of(arguments).map(this::typeName).toArray(String[]::new));
    }

    private boolean is(String type, String ... arguments) {
        if (!this.equalType(this.getType(), type)) {
            return false;
        }
        if (arguments.length > 0 && this.type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)this.type;
            List<? extends TypeMirror> args = declaredType.getTypeArguments();
            if (args.size() != arguments.length) {
                return false;
            }
            for (int i = 0; i < arguments.length; ++i) {
                if (this.equalType(args.get(i), arguments[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean equalType(TypeMirror type, String typeName) {
        if (!this.typeUtils.erasure(type).toString().equals(typeName)) {
            if (Enum.class.getName().equals(typeName)) {
                return this.typeUtils.asElement(type).getKind() == ElementKind.ENUM;
            }
            return false;
        }
        return true;
    }

    public boolean isParameterizedType() {
        if (this.type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)this.type;
            return declaredType.getTypeArguments().size() > 0;
        }
        return false;
    }

    public List<TypeDefinition> getArguments() {
        if (this.type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)this.type;
            ArrayList<TypeDefinition> result = new ArrayList<TypeDefinition>();
            for (TypeMirror typeMirror : declaredType.getTypeArguments()) {
                result.add(new TypeDefinition(this.typeUtils, typeMirror));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Type toJvmType() {
        return this.asmType(this.getName(this.type));
    }

    public boolean isRawType() {
        return this.type.toString().equals(this.getRawType().toString());
    }

    public String toString() {
        return this.type.toString();
    }

    private Type asmType(String type) {
        switch (type) {
            case "byte": {
                return Type.BYTE_TYPE;
            }
            case "byte[]": {
                return Type.getType(byte[].class);
            }
            case "int": {
                return Type.INT_TYPE;
            }
            case "int[]": {
                return Type.getType(int[].class);
            }
            case "long": {
                return Type.LONG_TYPE;
            }
            case "long[]": {
                return Type.getType(long[].class);
            }
            case "float": {
                return Type.FLOAT_TYPE;
            }
            case "float[]": {
                return Type.getType(float[].class);
            }
            case "double": {
                return Type.DOUBLE_TYPE;
            }
            case "double[]": {
                return Type.getType(double[].class);
            }
            case "boolean": {
                return Type.BOOLEAN_TYPE;
            }
            case "boolean[]": {
                return Type.getType(boolean[].class);
            }
            case "void": {
                return Type.VOID_TYPE;
            }
            case "short": {
                return Type.SHORT_TYPE;
            }
            case "short[]": {
                return Type.getType(short[].class);
            }
            case "char": {
                return Type.CHAR_TYPE;
            }
            case "char[]": {
                return Type.getType(char[].class);
            }
            case "String": {
                return Type.getType(String.class);
            }
            case "String[]": {
                return Type.getType(String[].class);
            }
        }
        String prefix = "";
        if (type.endsWith("[]")) {
            prefix = "[";
        }
        return Type.getObjectType(prefix + type.replace(".", "/"));
    }

    private String typeName(Class type) {
        return type.isArray() ? type.getComponentType().getName() + "[]" : type.getName();
    }

    private String getName(TypeMirror type) {
        Element element = this.typeUtils.asElement(type);
        return element == null ? type.toString() : this.getName(element);
    }

    private String getName(Element type) {
        Element parent = type.getEnclosingElement();
        if (parent != null && parent.getKind() == ElementKind.CLASS) {
            return this.getName(parent) + "$" + type.getSimpleName();
        }
        return type.toString();
    }
}

