/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.Context;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.Formdata;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Session;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.apt.Annotations;
import io.jooby.internal.apt.ParamKind;
import io.jooby.internal.apt.TypeDefinition;
import io.jooby.internal.apt.asm.ParamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Types;

public class ParamDefinition {
    private final VariableElement parameter;
    private final TypeDefinition type;
    private final Types typeUtils;
    private final ParamKind kind;
    private final String name;
    private final String httpName;

    private ParamDefinition(ProcessingEnvironment environment, VariableElement parameter) {
        this.typeUtils = environment.getTypeUtils();
        this.parameter = parameter;
        this.name = parameter.getSimpleName().toString();
        this.type = new TypeDefinition(this.typeUtils, parameter.asType());
        this.kind = this.computeKind();
        this.httpName = this.parameterName(parameter, this.kind.annotations());
    }

    public ParamWriter newWriter() {
        try {
            return this.getKind().newWriter();
        }
        catch (UnsupportedOperationException x) {
            throw new UnsupportedOperationException("No writer for: '" + this.toString() + "'; kind: " + (Object)((Object)this.getKind()));
        }
    }

    public String getHttpName() {
        return this.httpName;
    }

    public String getName() {
        return this.name;
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public ParamKind getKind() {
        return this.kind;
    }

    public boolean is(Class type, Class ... arguments) {
        return this.getType().is(type, arguments);
    }

    public boolean isOptional() {
        return this.is(Optional.class, new Class[0]);
    }

    public boolean isList() {
        return this.is(List.class, new Class[0]);
    }

    public boolean isNamed() {
        return this.isSimpleType();
    }

    public boolean isNullable() {
        boolean nonnull;
        if (this.hasAnnotation("org.jetbrains.annotations.Nullable") || this.hasAnnotation("javax.annotation.Nullable")) {
            return true;
        }
        boolean bl = nonnull = this.hasAnnotation("org.jetbrains.annotations.NotNull") || this.hasAnnotation("javax.annotation.Nonnull");
        if (nonnull) {
            return false;
        }
        return !this.getType().isPrimitive();
    }

    private boolean hasAnnotation(String type) {
        for (AnnotationMirror annotationMirror : this.parameter.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().equals(type)) continue;
            return true;
        }
        return false;
    }

    public Method getObjectValue() throws NoSuchMethodException {
        return this.getKind().valueObject(this);
    }

    public Method getSingleValue() throws NoSuchMethodException {
        return this.getKind().singleValue(this);
    }

    private boolean isSimpleType() {
        for (Class builtinType : this.builtinTypes()) {
            if (!this.is(builtinType, new Class[0]) && !this.is(Optional.class, builtinType) && !this.is(List.class, builtinType) && !this.is(Set.class, builtinType)) continue;
            return true;
        }
        return false;
    }

    private Class[] builtinTypes() {
        return new Class[]{String.class, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, Enum.class, UUID.class, Instant.class, Date.class, LocalDate.class, LocalDateTime.class, BigDecimal.class, BigInteger.class, Duration.class, Period.class, Charset.class, StatusCode.class, TimeZone.class, ZoneId.class, URI.class, URL.class};
    }

    public String toString() {
        return this.parameter.getSimpleName() + ": " + this.parameter.asType();
    }

    public Method getMethod() throws NoSuchMethodException {
        if (!this.isNullable()) {
            if (this.is(String.class, new Class[0])) {
                return Value.class.getDeclaredMethod("value", new Class[0]);
            }
            if (this.is(Integer.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("intValue", new Class[0]);
            }
            if (this.is(Byte.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("byteValue", new Class[0]);
            }
            if (this.is(Long.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("longValue", new Class[0]);
            }
            if (this.is(Float.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("floatValue", new Class[0]);
            }
            if (this.is(Double.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("doubleValue", new Class[0]);
            }
            if (this.is(Boolean.TYPE, new Class[0])) {
                return Value.class.getDeclaredMethod("booleanValue", new Class[0]);
            }
            if (this.is(Optional.class, String.class)) {
                return Value.class.getDeclaredMethod("toOptional", new Class[0]);
            }
            if (this.is(List.class, String.class)) {
                return Value.class.getDeclaredMethod("toList", new Class[0]);
            }
            if (this.is(Set.class, String.class)) {
                return Value.class.getDeclaredMethod("toSet", new Class[0]);
            }
        }
        if (this.isOptional()) {
            return ValueNode.class.getMethod("toOptional", Class.class);
        }
        if (this.isList()) {
            return ValueNode.class.getMethod("toList", Class.class);
        }
        if (this.is(Set.class, new Class[0])) {
            return ValueNode.class.getMethod("toSet", Class.class);
        }
        if (this.kind == ParamKind.BODY_PARAM) {
            return Context.class.getMethod("body", this.type.isRawType() ? Class.class : Type.class);
        }
        return ValueNode.class.getMethod("to", Class.class);
    }

    public static ParamDefinition create(ProcessingEnvironment environment, VariableElement parameter) {
        ParamDefinition definition = new ParamDefinition(environment, parameter);
        return definition;
    }

    private ParamKind computeKind() {
        if (this.isTypeInjection()) {
            return ParamKind.TYPE;
        }
        if (this.is(FileUpload.class, new Class[0]) || this.is(List.class, FileUpload.class) || this.is(Optional.class, FileUpload.class) || this.is(Path.class, new Class[0])) {
            return ParamKind.FILE_UPLOAD;
        }
        for (ParamKind strategy : ParamKind.values()) {
            if (!this.isParam(this.parameter, strategy.annotations())) continue;
            return strategy;
        }
        return ParamKind.BODY_PARAM;
    }

    private boolean isTypeInjection() {
        if (this.is(Context.class, new Class[0])) {
            return true;
        }
        if (this.is(QueryString.class, new Class[0])) {
            return true;
        }
        if (this.is(Formdata.class, new Class[0])) {
            return true;
        }
        if (this.is(Multipart.class, new Class[0])) {
            return true;
        }
        if (this.is(FlashMap.class, new Class[0])) {
            return true;
        }
        if (this.is(Session.class, new Class[0]) || this.is(Optional.class, Session.class)) {
            return true;
        }
        return this.is(Route.class, new Class[0]);
    }

    private boolean isParam(VariableElement parameter, Set<String> annotations) {
        return this.annotations(parameter.getAnnotationMirrors(), annotations).size() > 0;
    }

    private List<AnnotationMirror> annotations(List<? extends AnnotationMirror> annotationMirrors, Set<String> annotations) {
        return annotationMirrors.stream().filter(it -> {
            String rawType = new TypeDefinition(this.typeUtils, it.getAnnotationType()).getRawType().toString();
            return annotations.contains(rawType);
        }).collect(Collectors.toList());
    }

    private String parameterName(VariableElement parameter, Set<String> types) {
        return this.annotations(parameter.getAnnotationMirrors(), types).stream().flatMap(it -> Annotations.attribute(it, "value").stream()).findFirst().orElse(parameter.getSimpleName().toString());
    }
}

