/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt.asm;

import io.jooby.Route;
import io.jooby.SneakyThrows;
import io.jooby.internal.apt.Primitives;
import io.jooby.internal.apt.TypeDefinition;
import io.jooby.internal.apt.asm.ArrayWriter;
import io.jooby.internal.apt.asm.ClassWriter;
import io.jooby.internal.apt.asm.MethodVisitor;
import io.jooby.internal.apt.asm.Type;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class RouteAttributesWriter {
    private static final Predicate<String> HTTP_ANNOTATION = it -> it.startsWith("io.jooby.annotations") || it.startsWith("javax.ws.rs");
    private static final Predicate<String> NULL_ANNOTATION = it -> it.endsWith("NonNull") || it.endsWith("NotNull") || it.endsWith("Nullable");
    private static final Predicate<String> KOTLIN_ANNOTATION = it -> it.equals("kotlin.Metadata");
    private static final Predicate<String> ATTR_FILTER = HTTP_ANNOTATION.negate().and(NULL_ANNOTATION.negate()).and(KOTLIN_ANNOTATION.negate());
    private final Elements elements;
    private final Types types;
    private final String moduleInternalName;
    private final ClassWriter writer;
    private final MethodVisitor visitor;

    public RouteAttributesWriter(Elements elements, Types types, ClassWriter writer, String moduleInternalName, MethodVisitor visitor) {
        this.elements = elements;
        this.types = types;
        this.writer = writer;
        this.moduleInternalName = moduleInternalName;
        this.visitor = visitor;
    }

    public void process(ExecutableElement method, BiConsumer<String, Object[]> log) throws NoSuchMethodException {
        Method target = Route.class.getDeclaredMethod("attribute", String.class, Object.class);
        Map<String, Object> attributes = this.annotationMap(method);
        for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
            String name = attribute.getKey();
            Object value = attribute.getValue();
            log.accept("  %s: %s", new Object[]{name, value});
            this.visitor.visitVarInsn(25, 2);
            this.visitor.visitLdcInsn(name);
            this.annotationValue(this.writer, this.visitor, value);
            this.visitor.visitMethodInsn(182, Type.getInternalName(target.getDeclaringClass()), target.getName(), Type.getMethodDescriptor(target), false);
            this.visitor.visitInsn(87);
        }
    }

    private Map<String, Object> annotationMap(ExecutableElement method) {
        Map<String, Object> attributes = this.annotationMap(method.getEnclosingElement().getAnnotationMirrors(), null);
        attributes.putAll(this.annotationMap(method.getAnnotationMirrors(), null));
        return attributes;
    }

    private Map<String, Object> annotationMap(List<? extends AnnotationMirror> annotations, String root) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!ATTR_FILTER.test(annotationMirror.getAnnotationType().toString())) continue;
            String prefix = root == null ? annotationMirror.getAnnotationType().asElement().getSimpleName().toString() : root;
            this.toMap(annotationMirror.getElementValues(), prefix).forEach(result::put);
            this.toMap(this.elements.getElementValuesWithDefaults(annotationMirror), prefix).forEach(result::putIfAbsent);
        }
        return result;
    }

    private Map<String, Object> toMap(Map<? extends ExecutableElement, ? extends AnnotationValue> values, String prefix) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> attribute : values.entrySet()) {
            Object value = this.annotationValue(attribute.getValue());
            if (value == null) continue;
            String method = attribute.getKey().getSimpleName().toString();
            String name = method.equals("value") ? prefix : prefix + "." + method;
            result.putIfAbsent(name, value);
        }
        return result;
    }

    private Object annotationValue(AnnotationValue annotationValue) {
        Object value = annotationValue.getValue();
        if (value instanceof AnnotationMirror) {
            Map<String, Object> annotation = this.annotationMap(Collections.singletonList((AnnotationMirror)value), null);
            return annotation.isEmpty() ? null : annotation;
        }
        if (value instanceof VariableElement) {
            VariableElement vare = (VariableElement)annotationValue.getValue();
            TypeMirror typeMirror = vare.asType();
            Element element = this.types.asElement(typeMirror);
            Name binaryName = this.elements.getBinaryName((TypeElement)element);
            return new EnumValue(binaryName.toString(), value.toString());
        }
        if (value instanceof List) {
            List values = (List)value;
            if (values.size() > 0) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (AnnotationValue it : values) {
                    result.add(this.annotationValue(it));
                }
                return result;
            }
            return null;
        }
        return value;
    }

    private void annotationValue(ClassWriter writer, MethodVisitor visitor, Object value) throws NoSuchMethodException {
        if (value instanceof Map) {
            String newMap = this.annotationMapValue(writer, (Map)value);
            visitor.visitMethodInsn(184, this.moduleInternalName, newMap, "()Ljava/util/Map;", false);
        } else if (value instanceof List) {
            String componentType;
            List values = (List)value;
            String string = componentType = values.get(0) instanceof EnumValue ? ((EnumValue)values.get(0)).type : values.get(0).getClass().getName();
            if (values.size() > 0) {
                ArrayWriter.write(visitor, componentType, values, SneakyThrows.throwingConsumer(v -> this.annotationValue(writer, visitor, v)));
                Method asList = Arrays.class.getDeclaredMethod("asList", Object[].class);
                visitor.visitMethodInsn(184, Type.getInternalName(asList.getDeclaringClass()), asList.getName(), Type.getMethodDescriptor(asList), false);
            } else {
                Method emptyList = Collections.class.getDeclaredMethod("emptyList", new Class[0]);
                visitor.visitMethodInsn(184, Type.getInternalName(emptyList.getDeclaringClass()), emptyList.getName(), Type.getMethodDescriptor(emptyList), false);
            }
        } else {
            this.annotationSingleValue(visitor, value);
        }
    }

    private String annotationMapValue(ClassWriter writer, Map<String, Object> map) throws NoSuchMethodException {
        String methodName = "newMap" + Long.toHexString(UUID.randomUUID().getMostSignificantBits());
        MethodVisitor methodVisitor = writer.visitMethod(10, methodName, "()Ljava/util/Map;", "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, "java/util/HashMap");
        methodVisitor.visitInsn(89);
        methodVisitor.visitMethodInsn(183, "java/util/HashMap", "<init>", "()V", false);
        methodVisitor.visitVarInsn(58, 0);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitLdcInsn(entry.getKey());
            this.annotationValue(writer, methodVisitor, entry.getValue());
            methodVisitor.visitMethodInsn(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true);
            methodVisitor.visitInsn(87);
        }
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        return methodName;
    }

    private void annotationSingleValue(MethodVisitor visitor, Object value) throws NoSuchMethodException {
        if (value instanceof String) {
            visitor.visitLdcInsn(value);
        } else if (value instanceof Boolean) {
            this.annotationBoolean(visitor, (Boolean)value, false, 3, 4);
        } else if (value instanceof Character) {
            this.annotationCharacter(visitor, (Character)value, false, 3, 4, 5, 6, 7, 8);
        } else if (value instanceof Short) {
            this.annotationNumber(visitor, (Number)value, true, 3, 4, 5, 6, 7, 8);
        } else if (value instanceof Integer) {
            this.annotationNumber(visitor, (Number)value, true, 3, 4, 5, 6, 7, 8);
        } else if (value instanceof Long) {
            this.annotationNumber(visitor, (Number)value, false, 9, 10);
        } else if (value instanceof Float) {
            this.annotationNumber(visitor, (Number)value, false, 11, 12, 13);
        } else if (value instanceof Double) {
            this.annotationNumber(visitor, (Number)value, false, 14, 15);
        } else if (value instanceof TypeMirror) {
            TypeDefinition typeDef = new TypeDefinition(this.types, (TypeMirror)value);
            if (typeDef.isPrimitive()) {
                Method wrapper = Primitives.wrapper(typeDef);
                visitor.visitFieldInsn(178, Type.getInternalName(wrapper.getDeclaringClass()), "TYPE", "Ljava/lang/Class;");
            } else {
                visitor.visitLdcInsn(typeDef.toJvmType());
            }
        } else if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            Type type = Type.getObjectType(enumValue.type.replace(".", "/"));
            visitor.visitFieldInsn(178, type.getInternalName(), enumValue.value, type.getDescriptor());
        }
        Method wrapper = Primitives.wrapper(value.getClass());
        if (wrapper != null) {
            visitor.visitMethodInsn(184, Type.getInternalName(wrapper.getDeclaringClass()), wrapper.getName(), Type.getMethodDescriptor(wrapper), false);
        }
    }

    private void annotationBoolean(MethodVisitor visitor, Boolean value, boolean checkRange, Integer ... constants) {
        this.annotationPrimitive(visitor, value, checkRange, b -> b != false ? 1 : 0, constants);
    }

    private void annotationCharacter(MethodVisitor visitor, Character value, boolean checkRange, Integer ... constants) {
        this.annotationPrimitive(visitor, value, checkRange, c -> c.charValue(), constants);
    }

    private void annotationNumber(MethodVisitor visitor, Number value, boolean checkRange, Integer ... constants) {
        this.annotationPrimitive(visitor, value, checkRange, Number::intValue, constants);
    }

    private <T> void annotationPrimitive(MethodVisitor visitor, T value, boolean checkRange, SneakyThrows.Function<T, Integer> intMapper, Integer ... constants) {
        int v = (Integer)intMapper.apply(value);
        if (v >= 0 && v <= constants.length) {
            visitor.visitInsn(constants[v]);
        } else if (checkRange) {
            if (v >= -128 && v <= 127) {
                visitor.visitIntInsn(16, v);
            } else if (v >= Short.MIN_VALUE && v <= Short.MAX_VALUE) {
                visitor.visitIntInsn(17, v);
            } else {
                visitor.visitLdcInsn(value);
            }
        } else {
            visitor.visitLdcInsn(value);
        }
    }

    private static class EnumValue {
        private String type;
        private String value;

        public EnumValue(String type, String value) {
            this.type = type;
            this.value = value;
        }
    }
}

