/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.cli;

import io.jooby.cli.Cli;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import picocli.CommandLine;

public class Version
implements CommandLine.IVersionProvider {
    public static final String VERSION = Version.doVersion();

    @Override
    public String[] getVersion() {
        return new String[]{VERSION};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String doVersion() {
        try {
            URL url = URI.create("https://search.maven.org/solrsearch/select?q=+g:io.jooby+a:jooby&start=0&rows=1").toURL();
            URLConnection connection = url.openConnection();
            try (InputStreamReader in = new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8);){
                Map json = Cli.gson.fromJson((Reader)in, Map.class);
                Map response = (Map)json.get("response");
                List docs = (List)response.get("docs");
                Map jooby = (Map)docs.get(0);
                String string = (String)jooby.get("latestVersion");
                return string;
            }
        }
        catch (Exception x) {
            return Optional.ofNullable(Version.class.getPackage()).map(Package::getImplementationVersion).filter(Objects::nonNull).orElse("2.15.0");
        }
    }
}

