/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.graphql;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Route;
import io.jooby.ServiceRegistry;
import io.jooby.SneakyThrows;
import io.jooby.internal.graphql.BlockingGraphQLHandler;
import io.jooby.internal.graphql.GraphQLHandler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;

public class GraphQLModule
implements Extension {
    private GraphQL graphQL;
    private boolean async = true;
    private boolean supportGetRequest;

    public GraphQLModule(@Nonnull GraphQL graphQL) {
        this.graphQL = graphQL;
    }

    public GraphQLModule(@Nonnull GraphQLSchema schema) {
        this(GraphQL.newGraphQL((GraphQLSchema)schema).build());
    }

    public GraphQLModule(@Nonnull String path, @Nonnull RuntimeWiring wiring) {
        this(GraphQLModule.newSchema(GraphQLModule.reader(GraphQLModule.class.getClassLoader(), path), wiring));
    }

    public GraphQLModule(@Nonnull Path path, @Nonnull RuntimeWiring wiring) {
        this(GraphQLModule.newSchema(GraphQLModule.fileReader(path), wiring));
    }

    public GraphQLModule(@Nonnull RuntimeWiring wiring) {
        this("schema.graphql", wiring);
    }

    public void install(@Nonnull Jooby application) throws Exception {
        GraphQLHandler handler;
        String graphqlPath = application.getEnvironment().getProperty("graphql.path", "/graphql");
        GraphQLHandler graphQLHandler = handler = this.async ? new GraphQLHandler(this.graphQL) : new BlockingGraphQLHandler(this.graphQL);
        if (this.supportGetRequest) {
            this.executionMode(application.get(graphqlPath, (Route.Handler)handler), this.async);
        }
        this.executionMode(application.post(graphqlPath, (Route.Handler)handler), this.async);
        ServiceRegistry services = application.getServices();
        services.put(GraphQL.class, (Object)this.graphQL);
    }

    public GraphQLModule setAsync(boolean async) {
        this.async = async;
        return this;
    }

    public GraphQLModule setSupportGetRequest(boolean supportGetRequest) {
        this.supportGetRequest = supportGetRequest;
        return this;
    }

    private void executionMode(Route route, boolean async) {
        if (async) {
            route.setReturnType(CompletableFuture.class);
        } else {
            route.setReturnType(Map.class);
        }
    }

    private static Reader fileReader(Path path) {
        try {
            return Files.newBufferedReader(path);
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private static Reader reader(ClassLoader loader, @Nonnull String path) {
        try {
            return new InputStreamReader(loader.getResourceAsStream(path.startsWith("/") ? path.substring(0) : path), StandardCharsets.UTF_8);
        }
        catch (NullPointerException x) {
            throw SneakyThrows.propagate((Throwable)new FileNotFoundException(path));
        }
    }

    private static GraphQLSchema newSchema(Reader input, RuntimeWiring wiring) {
        TypeDefinitionRegistry typeRegistry = new SchemaParser().parse(input);
        SchemaGenerator schemaGenerator = new SchemaGenerator();
        return schemaGenerator.makeExecutableSchema(typeRegistry, wiring);
    }
}

