/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.graphql;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import io.jooby.Context;
import io.jooby.Route;
import io.jooby.internal.$shaded.gson.Gson;
import io.jooby.internal.$shaded.gson.GsonBuilder;
import io.jooby.internal.graphql.GraphQLRequest;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class GraphQLHandler
implements Route.Handler {
    private static final Gson json = new GsonBuilder().create();
    protected GraphQL graphQL;

    public GraphQLHandler(GraphQL graphQL) {
        this.graphQL = graphQL;
    }

    @Nonnull
    public Object apply(@Nonnull Context ctx) {
        return this.graphQL.executeAsync(this.newExecutionInput(ctx)).thenApply(ExecutionResult::toSpecification);
    }

    protected final ExecutionInput newExecutionInput(@Nonnull Context ctx) {
        GraphQLRequest request;
        if (ctx.getMethod().equals("POST")) {
            request = (GraphQLRequest)ctx.body(GraphQLRequest.class);
        } else {
            request = new GraphQLRequest();
            String query = ctx.query("query").value();
            String operationName = ctx.query("operationName").valueOrNull();
            Map variables = ctx.query("variables").toOptional().filter(string -> !string.equals("{}")).map(str -> json.fromJson((String)str, Map.class)).orElseGet(Collections::emptyMap);
            request.setOperationName(operationName);
            request.setQuery(query);
            request.setVariables(variables);
        }
        return ExecutionInput.newExecutionInput((String)request.getQuery()).operationName(request.getOperationName()).context((Object)ctx).variables(request.getVariables()).build();
    }
}

