/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.handlebars;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.ValueResolver;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.ModelAndView;
import io.jooby.TemplateEngine;
import io.jooby.buffer.DataBuffer;
import java.util.Collections;
import java.util.List;

public class HandlebarsTemplateEngine
implements TemplateEngine {
    private final Handlebars handlebars;
    private final ValueResolver[] resolvers;
    private final List<String> extensions;

    public HandlebarsTemplateEngine(Handlebars handlebars, ValueResolver[] resolvers, List<String> extensions) {
        this.handlebars = handlebars;
        this.resolvers = resolvers;
        this.extensions = Collections.unmodifiableList(extensions);
    }

    @NonNull
    public List<String> extensions() {
        return this.extensions;
    }

    public DataBuffer render(Context ctx, ModelAndView<?> modelAndView) throws Exception {
        Template template = this.handlebars.compile(modelAndView.getView());
        com.github.jknack.handlebars.Context engineModel = com.github.jknack.handlebars.Context.newBuilder((Object)modelAndView.getModel()).resolver(this.resolvers).build().data(ctx.getAttributes());
        DataBuffer buffer = ctx.getBufferFactory().allocateBuffer();
        template.apply(engineModel, buffer.asWriter());
        return buffer;
    }
}

