/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.jwt;

import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SessionToken;
import io.jooby.SneakyThrows;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JwtSessionStore
implements SessionStore {
    private final SessionStore store;

    public JwtSessionStore(@Nonnull String key) {
        this(key, SessionToken.signedCookie((Cookie)SessionToken.SID));
    }

    public JwtSessionStore(@Nonnull String key, @Nonnull SessionToken token) {
        this(Keys.hmacShaKeyFor((byte[])key.getBytes(StandardCharsets.UTF_8)), token);
    }

    public JwtSessionStore(@Nonnull Key key, @Nonnull SessionToken token) {
        this.store = SessionStore.signed((SessionToken)token, JwtSessionStore.decoder(key), JwtSessionStore.encoder(key));
    }

    @Nonnull
    public Session newSession(@Nonnull Context ctx) {
        return this.store.newSession(ctx);
    }

    @Nullable
    public Session findSession(@Nonnull Context ctx) {
        return this.store.findSession(ctx);
    }

    public void deleteSession(@Nonnull Context ctx, @Nonnull Session session) {
        this.store.deleteSession(ctx, session);
    }

    public void touchSession(@Nonnull Context ctx, @Nonnull Session session) {
        this.store.touchSession(ctx, session);
    }

    public void saveSession(@Nonnull Context ctx, @Nonnull Session session) {
        this.store.saveSession(ctx, session);
    }

    public void renewSessionId(@Nonnull Context ctx, @Nonnull Session session) {
        this.store.renewSessionId(ctx, session);
    }

    static SneakyThrows.Function<String, Map<String, String>> decoder(Key key) {
        return value -> {
            try {
                Jws claims = Jwts.parserBuilder().setSigningKey(key).build().parseClaimsJws(value);
                HashMap attributes = new HashMap();
                for (Map.Entry entry : ((Claims)claims.getBody()).entrySet()) {
                    attributes.put(entry.getKey(), entry.getValue().toString());
                }
                return attributes;
            }
            catch (JwtException x) {
                return null;
            }
        };
    }

    static SneakyThrows.Function<Map<String, String>, String> encoder(Key key) {
        return attributes -> {
            JwtBuilder builder = Jwts.builder().signWith(key);
            for (Map.Entry entry : attributes.entrySet()) {
                builder.claim((String)entry.getKey(), entry.getValue());
            }
            return builder.compact();
        };
    }
}

