/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.Router;
import io.jooby.internal.openapi.InsnSupport;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.Signature;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.LdcInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import java.util.Objects;

public class ContextPathParser {
    public static String parse(ParserContext ctx) {
        ClassNode classNode = ctx.classNode(ctx.getRouter());
        for (MethodNode method : classNode.methods) {
            String contextPath = InsnSupport.next(method.instructions.getFirst()).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(i -> {
                Signature signature = Signature.create(i);
                return signature.matches("setContextPath", String.class);
            }).findFirst().map(i -> InsnSupport.prev(i).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).map(c -> c.cst.toString()).orElse(null)).filter(Objects::nonNull).orElse(null);
            if (contextPath == null) continue;
            return Router.normalizePath((String)contextPath);
        }
        return "/";
    }
}

