/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public class Signature {
    private final Type[] argumentTypes;
    private Type owner;
    private String method;
    private String descriptor;

    public Signature(Type owner, String method, String descriptor) {
        this.owner = owner;
        this.method = method;
        this.descriptor = descriptor;
        this.argumentTypes = Type.getArgumentTypes(descriptor);
    }

    public Optional<Type> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public String getMethod() {
        return this.method;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public boolean matches(String method) {
        return this.method.equals(method);
    }

    public boolean matches(String method, Type ... parameterTypes) {
        if (this.matches(method)) {
            return this.matches(parameterTypes);
        }
        return false;
    }

    public boolean matches(Class owner, String method, Class ... parameterTypes) {
        if (Type.getType(owner).equals(this.owner)) {
            return this.matches(method, parameterTypes);
        }
        return false;
    }

    public boolean matches(Type owner, String method) {
        if (owner.equals(this.owner)) {
            return this.matches(method);
        }
        return false;
    }

    public boolean matches(String method, Class ... parameterTypes) {
        if (this.matches(method)) {
            return this.matches(parameterTypes);
        }
        return false;
    }

    public boolean matches(Class ... parameterTypes) {
        return this.matches((Type[])Stream.of(parameterTypes).map(Type::getType).toArray(Type[]::new));
    }

    public boolean matches(Type ... parameterTypes) {
        return Arrays.equals(this.argumentTypes, parameterTypes);
    }

    public int getParameterCount() {
        return this.argumentTypes.length;
    }

    public String toString() {
        return this.getMethod() + this.getDescriptor();
    }

    public static Signature create(MethodInsnNode node) {
        return new Signature(TypeFactory.fromInternalName(node.owner), node.name, node.desc);
    }

    public static Signature create(MethodNode node) {
        return new Signature(null, node.name, node.desc);
    }
}

