/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.run;

import io.jooby.internal.run.JoobyModuleFinder;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

public class JoobyMultiModuleFinder
extends JoobyModuleFinder {
    public JoobyMultiModuleFinder(String name, Set<Path> classes, Set<Path> resources, Set<Path> jars, Set<Path> watchDirs) {
        super(name, classes, resources, jars, watchDirs);
    }

    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) {
        Set<Path> resources = this.resources(name);
        if (resources == null) {
            return null;
        }
        return JoobyMultiModuleFinder.createModuleSpec(name, resources, this.dependencies(name, true));
    }

    @Override
    public Set<String> dependencies(String name) {
        return this.dependencies(name, false);
    }

    private Set<String> dependencies(String name, boolean addResources) {
        if (this.main.equals(name)) {
            return addResources ? Set.of("resources", "jars") : Set.of("jars");
        }
        if ("jars".equals(name)) {
            return addResources ? Set.of("resources", this.main) : Set.of(this.main);
        }
        return Collections.emptySet();
    }

    private Set<Path> resources(String name) {
        if (this.main.equals(name)) {
            return this.classes;
        }
        if ("resources".equals(name)) {
            return this.resources;
        }
        if ("jars".equals(name)) {
            return this.jars;
        }
        return null;
    }
}

