/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import com.typesafe.config.Config;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.di.ConfigPropertySource;
import io.jooby.di.SpringRegistry;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Controller;

public class Springby
implements Extension {
    private AnnotationConfigApplicationContext applicationContext;
    private boolean registerMvcRoutes = true;
    private boolean refresh = true;
    private String[] packages;

    public Springby(@Nonnull AnnotationConfigApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Springby() {
        this.applicationContext = null;
    }

    public Springby(String ... packages) {
        this.applicationContext = null;
        this.packages = packages;
    }

    public Springby noRefresh() {
        this.refresh = false;
        return this;
    }

    public Springby noMvcRoutes() {
        this.registerMvcRoutes = false;
        return this;
    }

    public void install(@Nonnull Jooby application) throws Exception {
        if (this.applicationContext == null) {
            String[] packages = this.packages;
            if (packages == null) {
                String basePackage = application.getBasePackage();
                if (basePackage == null) {
                    throw new IllegalArgumentException("Springby application context requires at least one package to scan.");
                }
                packages = new String[]{basePackage};
            }
            Environment environment = application.getEnvironment();
            this.applicationContext = Springby.defaultApplicationContext(packages);
            ConfigurableEnvironment configurableEnvironment = this.applicationContext.getEnvironment();
            String[] profiles = environment.getActiveNames().toArray(new String[0]);
            configurableEnvironment.setActiveProfiles(profiles);
            configurableEnvironment.setDefaultProfiles(profiles);
            Config config = environment.getConfig();
            MutablePropertySources propertySources = configurableEnvironment.getPropertySources();
            propertySources.addFirst((PropertySource)new ConfigPropertySource("application", config));
            ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
            beanFactory.registerSingleton("config", (Object)config);
            beanFactory.registerSingleton("environment", (Object)environment);
            application.onStop((AutoCloseable)this.applicationContext);
        }
        if (this.refresh) {
            this.applicationContext.refresh();
        }
        application.registry((Registry)new SpringRegistry((ApplicationContext)this.applicationContext));
        if (this.registerMvcRoutes) {
            String[] names = this.applicationContext.getBeanNamesForAnnotation(Controller.class);
            ClassLoader loader = application.getClass().getClassLoader();
            for (String name : names) {
                BeanDefinition bean = this.applicationContext.getBeanDefinition(name);
                Class<?> mvcClass = loader.loadClass(bean.getBeanClassName());
                application.mvc(mvcClass);
            }
        }
    }

    public static AnnotationConfigApplicationContext defaultApplicationContext(String ... packages) {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.scan(packages);
        return context;
    }
}

