/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.MediaType;
import io.jooby.MockValue;
import io.jooby.StatusCode;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockResponse
implements MockValue {
    private Object result;
    private StatusCode statusCode = StatusCode.OK;
    private Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private MediaType contentType;
    private long length = -1L;

    @Nonnull
    public Map<String, String> getHeaders() {
        return this.headers == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.headers);
    }

    @Nonnull
    public MockResponse setHeaders(@Nonnull Map<String, String> headers) {
        headers.forEach(this::setHeader);
        return this;
    }

    @Nonnull
    public MockResponse setHeader(@Nonnull String name, @Nonnull String value) {
        if ("content-type".equalsIgnoreCase(name)) {
            this.setContentType(MediaType.valueOf((String)value));
        } else if ("content-length".equalsIgnoreCase(name)) {
            this.setContentLength(Long.parseLong(value));
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    @Nullable
    public MediaType getContentType() {
        return this.contentType == null ? MediaType.text : this.contentType;
    }

    @Nonnull
    public MockResponse setContentType(@Nonnull MediaType contentType) {
        this.contentType = contentType;
        this.headers.put("content-type", contentType.toContentTypeHeader(contentType.getCharset()));
        return this;
    }

    public long getContentLength() {
        return this.length;
    }

    public MockResponse setContentLength(long length) {
        this.length = length;
        this.headers.put("content-length", Long.toString(length));
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public MockResponse setStatusCode(@Nonnull StatusCode statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    @Nonnull
    public Object value() {
        return this.result;
    }

    public MockResponse setResult(@Nonnull Object result) {
        this.result = result;
        return this;
    }
}

