/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Context;
import io.jooby.Jooby;
import io.jooby.MockContext;
import io.jooby.MockResponse;
import io.jooby.MockValue;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Throwing;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MockRouter {
    private static final Consumer NOOP = value -> {};
    private Supplier<Jooby> supplier = () -> application;
    private boolean fullExecution;

    public MockRouter(@Nonnull Jooby application) {
    }

    @Nonnull
    public MockValue get(@Nonnull String path) {
        return this.get(path, new MockContext());
    }

    @Nonnull
    public MockValue get(@Nonnull String path, @Nonnull Context context) {
        return this.call("GET", path, context);
    }

    public MockValue get(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.get(path, new MockContext(), consumer);
    }

    public MockValue get(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("GET", path, context, consumer);
    }

    public MockValue post(@Nonnull String path) {
        return this.post(path, new MockContext());
    }

    @Nonnull
    public MockValue post(@Nonnull String path, @Nonnull Context context) {
        return this.call("POST", path, context);
    }

    public MockValue post(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.post(path, new MockContext(), consumer);
    }

    public MockValue post(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("POST", path, context, consumer);
    }

    public MockValue delete(@Nonnull String path) {
        return this.delete(path, new MockContext());
    }

    @Nonnull
    public MockValue delete(@Nonnull String path, @Nonnull Context context) {
        return this.call("DELETE", path, context);
    }

    public MockValue delete(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.delete(path, new MockContext(), consumer);
    }

    public MockValue delete(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("DELETE", path, context, consumer);
    }

    public MockValue put(@Nonnull String path) {
        return this.put(path, new MockContext());
    }

    @Nonnull
    public MockValue put(@Nonnull String path, @Nonnull Context context) {
        return this.call("PUT", path, context);
    }

    public MockValue put(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.put(path, new MockContext(), consumer);
    }

    public MockValue put(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("PUT", path, context, consumer);
    }

    public MockValue patch(@Nonnull String path) {
        return this.patch(path, new MockContext());
    }

    @Nonnull
    public MockValue patch(@Nonnull String path, @Nonnull Context context) {
        return this.call("PATCH", path, context);
    }

    public MockValue patch(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.patch(path, new MockContext(), consumer);
    }

    public MockValue patch(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("PATCH", path, context, consumer);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull Context context) {
        return this.call(this.supplier.get(), method, path, context, NOOP);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.call(method, path, new MockContext(), consumer);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull MockContext ctx, @Nonnull Consumer<MockResponse> consumer) {
        return this.call(this.supplier.get(), method, path, ctx, consumer);
    }

    public MockRouter setFullExecution(boolean enabled) {
        this.fullExecution = enabled;
        return this;
    }

    private MockValue call(Jooby router, String method, String path, Context ctx, Consumer<MockResponse> consumer) {
        MockContext findContext = ctx instanceof MockContext ? (MockContext)ctx : new MockContext();
        findContext.setMethod(method.toUpperCase());
        findContext.setPathString(path);
        findContext.setRouter((Router)router);
        Router.Match match = router.match((Context)findContext);
        Route route = match.route();
        findContext.setPathMap(match.pathMap());
        findContext.setRoute(route);
        try {
            Route.Handler handler = this.fullExecution ? route.getPipeline() : route.getHandler();
            Object value = handler.apply(ctx);
            if (ctx instanceof MockContext) {
                MockResponse response = ((MockContext)ctx).getResponse();
                if (!(value instanceof Context)) {
                    response.setResult(value);
                }
                if (response.getContentLength() <= 0L) {
                    response.setContentLength(this.contentLength(value));
                }
                consumer.accept(response);
            }
            return new SingleMockValue(value);
        }
        catch (Exception x) {
            throw Throwing.sneakyThrow((Throwable)x);
        }
    }

    private long contentLength(Object value) {
        if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean) {
            return value.toString().length();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        return -1L;
    }

    private static class SingleMockValue
    implements MockValue {
        private final Object value;

        SingleMockValue(Object value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Object value() {
            return this.value;
        }
    }
}

