/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.AttachedFile;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MockResponse;
import io.jooby.MockSession;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Reified;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.Session;
import io.jooby.StatusCode;
import io.jooby.TypeMismatchException;
import io.jooby.Value;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockContext
implements DefaultContext {
    private String method = "GET";
    private Route route;
    private String pathString = "/";
    private Map<String, String> pathMap = new HashMap<String, String>();
    private String queryString;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private Formdata formdata = Formdata.create();
    private Multipart multipart = Multipart.create();
    private Body body;
    private Object bodyObject;
    private Map<String, MessageDecoder> decoders = new HashMap<String, MessageDecoder>();
    private Map<String, Object> responseHeaders = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private MockResponse response = new MockResponse();
    private Map<String, String> cookies = new LinkedHashMap<String, String>();
    private FlashMap flashMap = FlashMap.create((Context)this, (Cookie)new Cookie("jooby.sid").setHttpOnly(true));
    private Session session;
    private Router router;
    private List<FileUpload> files = new ArrayList<FileUpload>();

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    MockContext setMethod(@Nonnull String method) {
        this.method = method;
        return this;
    }

    @Nonnull
    public Session session() {
        if (this.session == null) {
            this.session = new MockSession();
        }
        return this.session;
    }

    @Nullable
    public Session sessionOrNull() {
        return this.session;
    }

    @Nonnull
    public Map<String, String> cookieMap() {
        return this.cookies;
    }

    @Nonnull
    public MockContext setCookieMap(@Nonnull Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    @Nonnull
    public FlashMap flash() {
        return this.flashMap;
    }

    public MockContext setFlashMap(@Nonnull FlashMap flashMap) {
        this.flashMap = flashMap;
        return this;
    }

    @Nonnull
    public MockContext setFlashAttribute(@Nonnull String name, @Nonnull String value) {
        this.flashMap.put((Object)name, (Object)value);
        return this;
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public MockContext setRoute(@Nonnull Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public String pathString() {
        return this.pathString;
    }

    public MockContext setPathString(@Nonnull String pathString) {
        int q = pathString.indexOf("?");
        if (q > 0) {
            this.pathString = pathString.substring(0, q);
            this.queryString = pathString.substring(q + 1);
        } else {
            this.pathString = pathString;
            this.queryString = null;
        }
        return this;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public MockContext setPathMap(@Nonnull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @Nonnull
    public QueryString query() {
        return QueryString.create((String)this.queryString);
    }

    @Nonnull
    public String queryString() {
        return this.queryString;
    }

    @Nonnull
    public Value header() {
        return Value.hash(this.headers);
    }

    @Nonnull
    public MockContext setHeaders(@Nonnull Map<String, Collection<String>> headers) {
        this.headers = headers;
        return this;
    }

    @Nonnull
    public MockContext setRequestHeader(@Nonnull String name, @Nonnull String value) {
        Collection values = this.headers.computeIfAbsent(name, k -> new ArrayList());
        values.add(value);
        return this;
    }

    @Nonnull
    public Formdata form() {
        return this.formdata;
    }

    @Nonnull
    public MockContext setForm(@Nonnull Formdata formdata) {
        this.formdata = formdata;
        return this;
    }

    @Nonnull
    public Multipart multipart() {
        return this.multipart;
    }

    @Nonnull
    public List<FileUpload> files() {
        return this.files;
    }

    public MockContext setFiles(@Nonnull List<FileUpload> files) {
        this.files = files;
        return this;
    }

    @Nonnull
    public List<FileUpload> files(@Nonnull String name) {
        return this.files.stream().filter(it -> it.name().equals(name)).collect(Collectors.toList());
    }

    @Nonnull
    public FileUpload file(@Nonnull String name) {
        return this.files.stream().filter(it -> it.name().equals(name)).findFirst().orElseThrow(() -> new TypeMismatchException(name, FileUpload.class));
    }

    @Nonnull
    public MockContext setMultipart(@Nonnull Multipart multipart) {
        this.multipart = multipart;
        return this;
    }

    @Nonnull
    public Body body() {
        if (this.body == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        return this.body;
    }

    @Nonnull
    public <T> T body(@Nonnull Reified<T> type) {
        if (this.bodyObject == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        if (!type.getRawType().isInstance(this.bodyObject)) {
            throw new TypeMismatchException("body", FileUpload.class);
        }
        return this.body(type, MediaType.text);
    }

    @Nonnull
    public <T> T body(@Nonnull Reified<T> type, @Nonnull MediaType contentType) {
        if (this.bodyObject == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        if (!type.getRawType().isInstance(this.bodyObject)) {
            throw new TypeMismatchException("body", type.getType());
        }
        return type.getRawType().cast(this.bodyObject);
    }

    @Nonnull
    public <T> T body(@Nonnull Class<T> type) {
        return this.body(type, MediaType.text);
    }

    @Nonnull
    public <T> T body(@Nonnull Class<T> type, @Nonnull MediaType contentType) {
        if (this.bodyObject == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        if (!type.isInstance(this.bodyObject)) {
            throw new TypeMismatchException("body", type);
        }
        return type.cast(this.bodyObject);
    }

    @Nonnull
    public MockContext setBody(@Nonnull Object body) {
        if (body instanceof Body) {
            this.body = (Body)body;
        } else {
            this.bodyObject = body;
        }
        return this;
    }

    @Nonnull
    public MockContext setBody(@Nonnull String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        return this.setBody(bytes);
    }

    @Nonnull
    public MockContext setBody(@Nonnull byte[] body) {
        this.body = Body.of((InputStream)new ByteArrayInputStream(body), (long)body.length);
        return this;
    }

    @Nonnull
    public MessageDecoder decoder(@Nonnull MediaType contentType) {
        return this.decoders.getOrDefault(contentType, MessageDecoder.UNSUPPORTED_MEDIA_TYPE);
    }

    public boolean isInIoThread() {
        return false;
    }

    @Nonnull
    public MockContext dispatch(@Nonnull Runnable action) {
        action.run();
        return this;
    }

    @Nonnull
    public MockContext dispatch(@Nonnull Executor executor, @Nonnull Runnable action) {
        action.run();
        return this;
    }

    @Nonnull
    public MockContext detach(@Nonnull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public MockContext removeResponseHeader(@Nonnull String name) {
        this.responseHeaders.remove(name);
        return this;
    }

    @Nonnull
    public MockContext setResponseHeader(@Nonnull String name, @Nonnull String value) {
        this.responseHeaders.put(name, value);
        return this;
    }

    @Nonnull
    public MockContext setResponseLength(long length) {
        this.response.setContentLength(length);
        return this;
    }

    public long getResponseLength() {
        return this.response.getContentLength();
    }

    @Nonnull
    public MockContext setResponseType(@Nonnull String contentType) {
        this.response.setContentType(MediaType.valueOf((String)contentType));
        return this;
    }

    @Nonnull
    public MockContext setResponseType(@Nonnull MediaType contentType, @Nullable Charset charset) {
        this.response.setContentType(contentType);
        return this;
    }

    @Nonnull
    public MockContext setResponseCode(int statusCode) {
        this.response.setStatusCode(StatusCode.valueOf((int)statusCode));
        return this;
    }

    @Nonnull
    public StatusCode getResponseCode() {
        return this.response.getStatusCode();
    }

    @Nonnull
    public MockContext render(@Nonnull Object result) {
        this.response.setResult(result);
        return this;
    }

    @Nonnull
    public MockResponse getResponse() {
        this.response.setHeaders(this.responseHeaders);
        return this.response;
    }

    @Nonnull
    public OutputStream responseStream() {
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        this.response.setResult(out);
        return out;
    }

    @Nonnull
    public Sender responseSender() {
        return new Sender(){

            public Sender write(@Nonnull byte[] data, @Nonnull Sender.Callback callback) {
                MockContext.this.response.setResult(data);
                callback.onComplete((Context)MockContext.this, null);
                return this;
            }

            public void close() {
            }
        };
    }

    @Nonnull
    public String getRemoteAddress() {
        return "0.0.0.0";
    }

    @Nonnull
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Nonnull
    public String getScheme() {
        return "http";
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        PrintWriter writer = new PrintWriter(new StringWriter());
        this.response.setResult(writer).setContentType(type);
        return writer;
    }

    @Nonnull
    public MockContext send(@Nonnull String data, @Nonnull Charset charset) {
        this.response.setResult(data).setContentLength(data.length());
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull byte[] data) {
        this.response.setResult(data).setContentLength(data.length);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull ByteBuffer data) {
        this.response.setResult(data).setContentLength(data.remaining());
        return this;
    }

    @Nonnull
    public MockContext send(InputStream input) {
        this.response.setResult(input);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull AttachedFile file) {
        this.response.setResult(file);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull Path file) {
        this.response.setResult(file);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull ReadableByteChannel channel) {
        this.response.setResult(channel);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull FileChannel file) {
        this.response.setResult(file);
        return this;
    }

    @Nonnull
    public MockContext send(StatusCode statusCode) {
        this.response.setContentLength(0L).setStatusCode(statusCode);
        return this;
    }

    @Nonnull
    public MockContext sendError(@Nonnull Throwable cause) {
        return this.sendError(cause, this.router.errorCode(cause));
    }

    @Nonnull
    public MockContext sendError(@Nonnull Throwable cause, @Nonnull StatusCode statusCode) {
        this.response.setResult(cause).setStatusCode(this.router.errorCode(cause));
        return this;
    }

    @Nonnull
    public MockContext setDefaultResponseType(@Nonnull MediaType contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    @Nonnull
    public MockContext setResponseCookie(@Nonnull Cookie cookie) {
        String setCookie = (String)this.response.getHeaders().get("Set-Cookie");
        setCookie = setCookie == null ? cookie.toCookieString() : setCookie + ";" + cookie.toCookieString();
        this.response.setHeader("Set-Cookie", setCookie);
        return this;
    }

    @Nonnull
    public MediaType getResponseType() {
        return this.response.getContentType();
    }

    @Nonnull
    public MockContext setResponseCode(@Nonnull StatusCode statusCode) {
        this.response.setStatusCode(statusCode);
        return this;
    }

    public boolean isResponseStarted() {
        return this.response.value() != null;
    }

    @Nonnull
    public Router getRouter() {
        return this.router;
    }

    @Nonnull
    MockContext setRouter(@Nonnull Router router) {
        this.router = router;
        return this;
    }

    public String toString() {
        return this.method + " " + this.pathString;
    }
}

