/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Session;
import io.jooby.Value;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;

public class MockSession
implements Session {
    private String sessionId;
    private Map<String, String> data = new HashMap<String, String>();
    private Instant creationTime;
    private Instant lastAccessedTime;
    private boolean isNew;
    private boolean modified;

    public MockSession(@Nonnull String sessionId) {
        this.sessionId = sessionId;
        this.creationTime = Instant.now();
        this.lastAccessedTime = Instant.now();
    }

    public MockSession() {
        this(UUID.randomUUID().toString());
    }

    @Nonnull
    public String getId() {
        return this.sessionId;
    }

    @Nonnull
    public Value get(@Nonnull String name) {
        return Optional.ofNullable(this.data.get(name)).map(value -> Value.create((String)name, (String)value)).orElse(Value.missing((String)name));
    }

    @Nonnull
    public Session put(@Nonnull String name, @Nonnull String value) {
        this.data.put(name, value);
        return this;
    }

    @Nonnull
    public Value remove(@Nonnull String name) {
        Value value = this.get(name);
        this.data.remove(name);
        return value;
    }

    @Nonnull
    public Map<String, String> toMap() {
        return this.data;
    }

    @Nonnull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Nonnull
    public Session setCreationTime(@Nonnull Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Nonnull
    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Nonnull
    public Session setLastAccessedTime(@Nonnull Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Nonnull
    public Session setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public boolean isModify() {
        return this.modified;
    }

    @Nonnull
    public Session setModify(boolean modify) {
        this.modified = modify;
        return this;
    }

    public Session clear() {
        this.data.clear();
        return this;
    }

    public void destroy() {
        this.clear();
    }
}

