/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import com.typesafe.config.Config;
import io.jooby.Environment;
import io.jooby.ExecutionMode;
import io.jooby.Jooby;
import io.jooby.JoobyTest;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Optional;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class JoobyExtension
implements BeforeAllCallback,
BeforeEachCallback,
AfterAllCallback,
AfterEachCallback,
ParameterResolver,
TestInstancePostProcessor {
    private static final int DEFAULT_PORT = 8911;

    public void beforeAll(ExtensionContext context) throws Exception {
        context.getElement().ifPresent(SneakyThrows.throwingConsumer(element -> {
            JoobyTest metadata = element.getAnnotation(JoobyTest.class);
            if (metadata != null) {
                this.startApp(context, metadata);
            }
        }));
    }

    private Jooby startApp(ExtensionContext context, JoobyTest metadata) throws Exception {
        String factoryMethod = metadata.factoryMethod();
        Jooby app = factoryMethod.isEmpty() ? Jooby.createApp((String[])new String[]{metadata.environment()}, (ExecutionMode)metadata.executionMode(), metadata.value()) : this.fromFactoryMethod(context, metadata, factoryMethod);
        ServerOptions serverOptions = app.getServerOptions();
        if (serverOptions == null) {
            serverOptions = new ServerOptions();
            app.setServerOptions(serverOptions);
        }
        serverOptions.setPort(this.port(metadata.port(), 8911));
        Server server = app.start();
        ExtensionContext.Store store = this.getStore(context);
        store.put((Object)"server", (Object)server);
        store.put((Object)"application", (Object)app);
        return app;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        context.getElement().ifPresent(SneakyThrows.throwingConsumer(element -> {
            JoobyTest metadata = element.getAnnotation(JoobyTest.class);
            if (metadata != null) {
                this.startApp(context, metadata);
            }
        }));
    }

    public void afterAll(ExtensionContext context) throws Exception {
        Server server = (Server)this.getStore(context).get((Object)"server", Server.class);
        if (server != null) {
            server.stop();
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        Server server = (Server)this.getStore(context).get((Object)"server", Server.class);
        if (server != null) {
            server.stop();
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.joobyParameter(context, parameterContext) != null;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        return this.joobyParameter(context, parameterContext).get();
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        Optional testMethod = context.getTestMethod();
        ExtensionContext.Namespace namespace = testMethod.map(m -> ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass(), m})).orElseGet(() -> ExtensionContext.Namespace.create((Object[])new Object[]{context.getRequiredTestClass()}));
        return context.getStore(namespace);
    }

    private Supplier<Object> joobyParameter(ExtensionContext context, ParameterContext parameterContext) {
        Parameter parameter = parameterContext.getParameter();
        return this.injectionPoint(context, parameter.getType(), () -> this.parameterName(parameter));
    }

    private String parameterName(Parameter parameter) {
        if (!parameter.isNamePresent()) {
            throw new IllegalStateException("Parameter injection requires parameter names to be present at runtime. Make sure compiler has the -parameters option");
        }
        return parameter.getName();
    }

    private Supplier<Object> injectionPoint(ExtensionContext context, Class type, Supplier<String> name) {
        if (Jooby.class.isAssignableFrom(type)) {
            return () -> this.application(context);
        }
        if (Environment.class.isAssignableFrom(type)) {
            return () -> this.application(context).getEnvironment();
        }
        if (Config.class.isAssignableFrom(type)) {
            return () -> this.application(context).getEnvironment().getConfig();
        }
        if (type == String.class && name.get().equals("serverPath")) {
            return () -> {
                Jooby app = this.application(context);
                return "http://localhost:" + app.getServerOptions().getPort() + app.getContextPath();
            };
        }
        if (type == Integer.TYPE && name.get().equals("serverPort")) {
            return () -> {
                Jooby app = this.application(context);
                return app.getServerOptions().getPort();
            };
        }
        return null;
    }

    private Jooby application(ExtensionContext context) {
        Jooby application = (Jooby)this.getStore(context).get((Object)"application", Jooby.class);
        if (application == null) {
            ExtensionContext parent = (ExtensionContext)context.getParent().orElseThrow(() -> new IllegalStateException("Application not found"));
            application = (Jooby)this.getStore(parent).get((Object)"application", Jooby.class);
        }
        if (application == null) {
            throw new IllegalStateException("Application not found");
        }
        return application;
    }

    private int port(int port, int fallback) {
        return port == -1 ? fallback : port;
    }

    public void postProcessTestInstance(Object instance, ExtensionContext context) throws Exception {
        for (Field field : instance.getClass().getDeclaredFields()) {
            Supplier<Object> injectionPoint;
            if (Modifier.isStatic(field.getModifiers()) || (injectionPoint = this.injectionPoint(context, field.getType(), () -> field.getName())) == null) continue;
            field.setAccessible(true);
            field.set(instance, injectionPoint.get());
        }
    }

    private Jooby fromFactoryMethod(ExtensionContext context, JoobyTest metadata, String factoryMethod) throws Exception {
        Class factoryClass = metadata.factoryClass();
        if (factoryClass == Object.class) {
            factoryClass = context.getRequiredTestClass();
        }
        try {
            Method factory = factoryClass.getMethod(factoryMethod, new Class[0]);
            Class<?> returnType = factory.getReturnType();
            if (!Jooby.class.isAssignableFrom(returnType)) {
                throw new IllegalStateException("Factory method must return a Jooby application: " + factory);
            }
            if (Modifier.isStatic(factory.getModifiers())) {
                return (Jooby)factory.invoke(null, new Object[0]);
            }
            return (Jooby)factory.invoke(context.getRequiredTestInstance(), new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw SneakyThrows.propagate((Throwable)e);
        }
    }

    static {
        System.setProperty("jooby.useShutdownHook", "false");
    }
}

