/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Context;
import io.jooby.MockContext;
import io.jooby.Session;
import io.jooby.Value;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockSession
implements Session {
    private MockContext ctx;
    private String sessionId;
    private Map<String, String> data = new HashMap<String, String>();
    private Instant creationTime;
    private Instant lastAccessedTime;
    private boolean isNew;
    private boolean modified;

    public MockSession(@Nonnull MockContext ctx, @Nonnull String sessionId) {
        this.ctx = ctx;
        this.sessionId = sessionId;
        this.creationTime = Instant.now();
        this.lastAccessedTime = Instant.now();
    }

    public MockSession(@Nonnull MockContext ctx) {
        this(ctx, UUID.randomUUID().toString());
    }

    @Nonnull
    public String getId() {
        return this.sessionId;
    }

    @Nonnull
    public MockSession setId(@Nullable String id) {
        this.sessionId = id;
        return this;
    }

    @Nonnull
    public Value get(@Nonnull String name) {
        return (Value)Optional.ofNullable(this.data.get(name)).map(value -> Value.create((Context)this.ctx, (String)name, (String)value)).orElse(Value.missing((String)name));
    }

    @Nonnull
    public Session put(@Nonnull String name, @Nonnull String value) {
        this.data.put(name, value);
        return this;
    }

    @Nonnull
    public Value remove(@Nonnull String name) {
        Value value = this.get(name);
        this.data.remove(name);
        return value;
    }

    @Nonnull
    public Map<String, String> toMap() {
        return this.data;
    }

    @Nonnull
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Nonnull
    public Session setCreationTime(@Nonnull Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    @Nonnull
    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Nonnull
    public Session setLastAccessedTime(@Nonnull Instant lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
        return this;
    }

    public boolean isNew() {
        return this.isNew;
    }

    @Nonnull
    public Session setNew(boolean isNew) {
        this.isNew = isNew;
        return this;
    }

    public boolean isModify() {
        return this.modified;
    }

    @Nonnull
    public Session setModify(boolean modify) {
        this.modified = modify;
        return this;
    }

    public Session clear() {
        this.data.clear();
        return this;
    }

    public Session renewId() {
        return this;
    }

    public void destroy() {
        this.clear();
    }
}

