/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Context;
import io.jooby.MockWebSocketConfigurer;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class MockWebSocket
implements WebSocket {
    private final MockWebSocketConfigurer configurer;
    private Context ctx;
    private boolean open = true;

    MockWebSocket(Context ctx, MockWebSocketConfigurer configurer) {
        this.ctx = ctx;
        this.configurer = configurer;
    }

    @Nonnull
    public Context getContext() {
        return this.ctx;
    }

    @Nonnull
    public List<WebSocket> getSessions() {
        return Collections.emptyList();
    }

    public boolean isOpen() {
        return this.open;
    }

    @Nonnull
    public WebSocket send(@Nonnull String message, boolean broadcast) {
        return this.sendObject(message, broadcast);
    }

    @Nonnull
    public WebSocket send(@Nonnull byte[] message, boolean broadcast) {
        return this.sendObject(message, broadcast);
    }

    @Nonnull
    public WebSocket render(@Nonnull Object value, boolean broadcast) {
        return this.sendObject(value, broadcast);
    }

    @Nonnull
    public WebSocket close(@Nonnull WebSocketCloseStatus closeStatus) {
        try {
            this.open = false;
            this.configurer.fireClose(closeStatus);
        }
        catch (Throwable x) {
            this.handleError(x);
        }
        return this;
    }

    private WebSocket sendObject(Object message, boolean broadcast) {
        try {
            if (!this.open) {
                throw new IllegalStateException("Attempt to send a message on closed web socket");
            }
            this.configurer.fireClientMessage(message);
        }
        catch (Throwable x) {
            this.handleError(x);
        }
        return this;
    }

    private void handleError(Throwable error) {
        this.configurer.fireError(error);
        if (SneakyThrows.isFatal((Throwable)error)) {
            throw SneakyThrows.propagate((Throwable)error);
        }
    }
}

