/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Context;
import io.jooby.Jooby;
import io.jooby.MockContext;
import io.jooby.MockResponse;
import io.jooby.MockSession;
import io.jooby.MockValue;
import io.jooby.MockWebSocketClient;
import io.jooby.MockWebSocketConfigurer;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class MockRouter {
    private static final Consumer NOOP = value -> {};
    private Executor worker;
    private Supplier<Jooby> supplier = () -> application;
    private boolean fullExecution;
    private MockSession session;

    public MockRouter(@Nonnull Jooby application) {
    }

    @Nonnull
    public MockRouter setSession(@Nonnull MockSession session) {
        this.session = session;
        return this;
    }

    public Executor getWorker() {
        return this.worker;
    }

    public MockRouter setWorker(@Nonnull Executor worker) {
        this.worker = worker;
        return this;
    }

    @Nonnull
    public MockValue get(@Nonnull String path) {
        return this.get(path, (Context)this.newContext());
    }

    public MockWebSocketClient ws(@Nonnull String path, Consumer<MockWebSocketClient> callback) {
        MockValue value = this.get(path, (Context)this.newContext());
        if (value.value() instanceof MockWebSocketConfigurer) {
            MockWebSocketConfigurer configurer = value.value(MockWebSocketConfigurer.class);
            MockWebSocketClient client = configurer.getClient();
            configurer.ready();
            callback.accept(client);
            client.init();
            return client;
        }
        throw new IllegalArgumentException("No websocket fount at: " + path);
    }

    private MockContext newContext() {
        MockContext ctx = new MockContext();
        if (this.session != null) {
            new MockSession(ctx, this.session);
        }
        return ctx;
    }

    @Nonnull
    public MockValue get(@Nonnull String path, @Nonnull Context context) {
        return this.call("GET", path, context);
    }

    public MockValue get(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.get(path, this.newContext(), consumer);
    }

    public MockValue get(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("GET", path, context, consumer);
    }

    public MockValue post(@Nonnull String path) {
        return this.post(path, (Context)this.newContext());
    }

    @Nonnull
    public MockValue post(@Nonnull String path, @Nonnull Context context) {
        return this.call("POST", path, context);
    }

    public MockValue post(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.post(path, this.newContext(), consumer);
    }

    public MockValue post(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("POST", path, context, consumer);
    }

    public MockValue delete(@Nonnull String path) {
        return this.delete(path, (Context)this.newContext());
    }

    @Nonnull
    public MockValue delete(@Nonnull String path, @Nonnull Context context) {
        return this.call("DELETE", path, context);
    }

    public MockValue delete(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.delete(path, this.newContext(), consumer);
    }

    public MockValue delete(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("DELETE", path, context, consumer);
    }

    public MockValue put(@Nonnull String path) {
        return this.put(path, (Context)this.newContext());
    }

    @Nonnull
    public MockValue put(@Nonnull String path, @Nonnull Context context) {
        return this.call("PUT", path, context);
    }

    public MockValue put(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.put(path, this.newContext(), consumer);
    }

    public MockValue put(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("PUT", path, context, consumer);
    }

    public MockValue patch(@Nonnull String path) {
        return this.patch(path, (Context)this.newContext());
    }

    @Nonnull
    public MockValue patch(@Nonnull String path, @Nonnull Context context) {
        return this.call("PATCH", path, context);
    }

    public MockValue patch(@Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.patch(path, this.newContext(), consumer);
    }

    public MockValue patch(@Nonnull String path, @Nonnull MockContext context, @Nonnull Consumer<MockResponse> consumer) {
        return this.call("PATCH", path, context, consumer);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull Context context) {
        return this.call(this.supplier.get(), method, path, context, NOOP);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull Consumer<MockResponse> consumer) {
        return this.call(method, path, this.newContext(), consumer);
    }

    public MockValue call(@Nonnull String method, @Nonnull String path, @Nonnull MockContext ctx, @Nonnull Consumer<MockResponse> consumer) {
        return this.call(this.supplier.get(), method, path, (Context)ctx, consumer);
    }

    public MockRouter setFullExecution(boolean enabled) {
        this.fullExecution = enabled;
        return this;
    }

    private MockValue call(Jooby router, String method, String path, Context ctx, Consumer<MockResponse> consumer) {
        boolean isCoroutine;
        MockContext findContext = ctx instanceof MockContext ? (MockContext)ctx : this.newContext();
        findContext.setMethod(method.toUpperCase());
        findContext.setRequestPath(path);
        findContext.setRouter((Router)router);
        findContext.setConsumer(consumer);
        findContext.setMockRouter(this);
        Router.Match match = router.match((Context)findContext);
        Route route = match.route();
        boolean bl = isCoroutine = route.attribute("coroutine") == Boolean.TRUE;
        if (isCoroutine) {
            router.setWorker(Optional.ofNullable(this.getWorker()).orElseGet(MockRouter::singleThreadWorker));
        }
        findContext.setPathMap((Map<String, String>)match.pathMap());
        findContext.setRoute(route);
        try {
            Route.Handler handler;
            Route.Handler handler2 = handler = this.fullExecution ? route.getPipeline() : route.getHandler();
            if (route.getMethod().equals("WS")) {
                WebSocket.Initializer initializer = (WebSocket.Initializer)route.getHandle();
                MockWebSocketConfigurer configurer = new MockWebSocketConfigurer(ctx, initializer);
                return new SingleMockValue(configurer);
            }
            Object value = handler.apply(ctx);
            if (ctx instanceof MockContext) {
                Object responseValue;
                MockResponse response = ((MockContext)ctx).getResponse();
                if (isCoroutine) {
                    response.getLatch().await();
                    responseValue = response.value();
                } else {
                    if (value != null && !(value instanceof Context)) {
                        response.setResult(value);
                    }
                    responseValue = Optional.ofNullable(response.value()).orElse(value);
                }
                if (response.getContentLength() <= 0L) {
                    response.setContentLength(this.contentLength(responseValue));
                }
                consumer.accept(response);
                return new SingleMockValue(responseValue);
            }
            return new SingleMockValue(value);
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private long contentLength(Object value) {
        if (value instanceof CharSequence || value instanceof Number || value instanceof Boolean) {
            return value.toString().length();
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length;
        }
        return -1L;
    }

    private static Executor singleThreadWorker() {
        return Executors.newSingleThreadExecutor(task -> {
            Thread thread = new Thread(task, "single-thread");
            thread.setDaemon(true);
            return thread;
        });
    }

    private static class SingleMockValue
    implements MockValue {
        private final Object value;

        SingleMockValue(Object value) {
            this.value = value;
        }

        @Override
        @Nonnull
        public Object value() {
            return this.value;
        }
    }
}

