/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Context;
import io.jooby.MockWebSocket;
import io.jooby.MockWebSocketClient;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class MockWebSocketConfigurer
implements WebSocketConfigurer {
    private final Context ctx;
    private final MockWebSocketClient client;
    private final MockWebSocket ws;
    private WebSocket.OnClose onClose;
    private WebSocket.OnConnect onConnect;
    private WebSocket.OnMessage onMessage;
    private WebSocket.OnError onError;

    MockWebSocketConfigurer(Context ctx, WebSocket.Initializer initializer) {
        this.ctx = ctx;
        initializer.init(ctx, (WebSocketConfigurer)this);
        this.client = new MockWebSocketClient(this);
        this.ws = new MockWebSocket(ctx, this);
    }

    @Nonnull
    public WebSocketConfigurer onConnect(@Nonnull WebSocket.OnConnect callback) {
        this.onConnect = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onMessage(@Nonnull WebSocket.OnMessage callback) {
        this.onMessage = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onError(@Nonnull WebSocket.OnError callback) {
        this.onError = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onClose(@Nonnull WebSocket.OnClose callback) {
        this.onClose = callback;
        return this;
    }

    MockWebSocketClient getClient() {
        return this.client;
    }

    void fireClientMessage(Object message) {
        this.client.fireMessage(message);
    }

    void ready() {
        try {
            if (this.onConnect != null) {
                this.onConnect.onConnect((WebSocket)this.ws);
            }
        }
        catch (Throwable x) {
            this.fireError(x);
        }
    }

    void fireOnMessage(Object message) {
        if (this.onMessage != null) {
            this.onMessage.onMessage((WebSocket)this.ws, message instanceof WebSocketMessage ? (WebSocketMessage)message : WebSocketMessage.create((Context)this.ctx, (String)message.toString()));
        }
    }

    void fireClose(WebSocketCloseStatus closeStatus) {
        if (this.onClose != null) {
            this.onClose.onClose((WebSocket)this.ws, closeStatus);
        }
        this.client.fireClose(closeStatus);
    }

    void fireError(Throwable cause) {
        if (this.onError != null) {
            this.onError.onError((WebSocket)this.ws, cause);
        } else {
            LoggerFactory.getLogger(MockWebSocket.class).error("WebSocket resulted in exception", cause);
        }
    }
}

