/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jooby.Body;
import io.jooby.CompletionListeners;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileDownload;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.QueryString;
import io.jooby.Reified;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.exception.TypeMismatchException;
import io.jooby.test.MockResponse;
import io.jooby.test.MockRouter;
import io.jooby.test.MockSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MockContext
implements DefaultContext {
    private String method = "GET";
    private Route route;
    private String requestPath = "/";
    private Map<String, String> pathMap = new HashMap<String, String>();
    private String queryString;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private Formdata formdata = Formdata.create((Context)this);
    private Body body;
    private Object bodyObject;
    private Map<String, MessageDecoder> decoders = new HashMap<String, MessageDecoder>();
    private Map<String, Object> responseHeaders = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private MockResponse response = new MockResponse();
    private Map<String, String> cookies = new LinkedHashMap<String, String>();
    private FlashMap flashMap = FlashMap.create((Context)this, (Cookie)new Cookie("jooby.sid").setHttpOnly(true));
    private Session session;
    private Router router;
    private Map<String, List<FileUpload>> files = new LinkedHashMap<String, List<FileUpload>>();
    private boolean responseStarted;
    private boolean resetHeadersOnError = true;
    private CompletionListeners listeners = new CompletionListeners();
    private Consumer<MockResponse> consumer;
    private MockRouter mockRouter;
    private String remoteAddress = "0.0.0.0";
    private String host;
    private String scheme = "http";
    private int port = -1;

    @NonNull
    public String getMethod() {
        return this.method;
    }

    @NonNull
    public Context setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @NonNull
    public MockContext setMethod(@NonNull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    @NonNull
    public Session session() {
        if (this.session == null) {
            this.session = new MockSession(this);
        }
        return this.session;
    }

    @NonNull
    public MockContext setSession(@NonNull MockSession session) {
        this.session = session;
        return this;
    }

    @Nullable
    public Session sessionOrNull() {
        return this.session;
    }

    @NonNull
    public Map<String, String> cookieMap() {
        return this.cookies;
    }

    @NonNull
    public Object forward(@NonNull String path) {
        this.setRequestPath(path);
        if (this.mockRouter != null) {
            return this.mockRouter.call(this.getMethod(), path, this, this.consumer).value();
        }
        return this;
    }

    @NonNull
    public MockContext setCookieMap(@NonNull Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    @NonNull
    public FlashMap flash() {
        return this.flashMap;
    }

    public MockContext setFlashMap(@NonNull FlashMap flashMap) {
        this.flashMap = flashMap;
        return this;
    }

    @NonNull
    public MockContext setFlashAttribute(@NonNull String name, @NonNull String value) {
        this.flashMap.put((Object)name, (Object)value);
        return this;
    }

    @NonNull
    public Route getRoute() {
        return this.route;
    }

    @NonNull
    public MockContext setRoute(@NonNull Route route) {
        this.route = route;
        return this;
    }

    @NonNull
    public String getRequestPath() {
        return this.requestPath;
    }

    @NonNull
    public MockContext setRequestPath(@NonNull String pathString) {
        int q = pathString.indexOf("?");
        this.requestPath = q > 0 ? pathString.substring(0, q) : pathString;
        return this;
    }

    @NonNull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @NonNull
    public MockContext setPathMap(@NonNull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @NonNull
    public QueryString query() {
        return QueryString.create((Context)this, (String)this.queryString);
    }

    @NonNull
    public String queryString() {
        return this.queryString;
    }

    @NonNull
    public MockContext setQueryString(@NonNull String queryString) {
        this.queryString = queryString;
        return this;
    }

    @NonNull
    public ValueNode header() {
        return Value.headers((Context)this, this.headers);
    }

    @NonNull
    public MockContext setHeaders(@NonNull Map<String, Collection<String>> headers) {
        this.headers = headers;
        return this;
    }

    @NonNull
    public MockContext setRequestHeader(@NonNull String name, @NonNull String value) {
        Collection values = this.headers.computeIfAbsent(name, k -> new ArrayList());
        values.add(value);
        return this;
    }

    @NonNull
    public Formdata form() {
        return this.formdata;
    }

    @NonNull
    public List<FileUpload> files() {
        return this.files.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public MockContext setFile(@NonNull String name, @NonNull FileUpload file) {
        this.files.computeIfAbsent(name, k -> new ArrayList()).add(file);
        return this;
    }

    @NonNull
    public List<FileUpload> files(@NonNull String name) {
        return this.files.entrySet().stream().filter(it -> ((String)it.getKey()).equals(name)).flatMap(it -> ((List)it.getValue()).stream()).collect(Collectors.toList());
    }

    @NonNull
    public FileUpload file(@NonNull String name) {
        return this.files.entrySet().stream().filter(it -> ((String)it.getKey()).equals(name)).findFirst().map(it -> (FileUpload)((List)it.getValue()).get(0)).orElseThrow(() -> new TypeMismatchException(name, FileUpload.class));
    }

    @NonNull
    public MockContext setForm(@NonNull Formdata formdata) {
        this.formdata = formdata;
        return this;
    }

    @NonNull
    public Body body() {
        if (this.body == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        return this.body;
    }

    @NonNull
    public <T> T body(@NonNull Class<T> type) {
        return this.decode(type, MediaType.text);
    }

    @NonNull
    public <T> T body(@NonNull Type type) {
        return this.decode(type, MediaType.text);
    }

    @NonNull
    public <T> T decode(@NonNull Type type, @NonNull MediaType contentType) {
        if (this.bodyObject == null) {
            throw new IllegalStateException("No body was set, use setBodyObject() to set one.");
        }
        Reified reified = Reified.get((Type)type);
        if (!reified.getRawType().isInstance(this.bodyObject)) {
            throw new TypeMismatchException("body", type);
        }
        return (T)this.bodyObject;
    }

    @NonNull
    public MockContext setBody(@NonNull Body body) {
        this.body = body;
        return this;
    }

    @NonNull
    public MockContext setBodyObject(@NonNull Object body) {
        this.bodyObject = body;
        return this;
    }

    @NonNull
    public MockContext setBody(@NonNull String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        return this.setBody(bytes);
    }

    @NonNull
    public MockContext setBody(@NonNull byte[] body) {
        this.setBody(Body.of((Context)this, (InputStream)new ByteArrayInputStream(body), (long)body.length));
        return this;
    }

    @NonNull
    public MessageDecoder decoder(@NonNull MediaType contentType) {
        return this.decoders.getOrDefault(contentType, MessageDecoder.UNSUPPORTED_MEDIA_TYPE);
    }

    public boolean isInIoThread() {
        return false;
    }

    @NonNull
    public MockContext dispatch(@NonNull Runnable action) {
        action.run();
        return this;
    }

    @NonNull
    public MockContext dispatch(@NonNull Executor executor, @NonNull Runnable action) {
        action.run();
        return this;
    }

    @NonNull
    public MockContext detach(@NonNull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @NonNull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @NonNull
    public MockContext removeResponseHeader(@NonNull String name) {
        this.responseHeaders.remove(name);
        return this;
    }

    @Nullable
    public String getResponseHeader(@NonNull String name) {
        Object value = this.responseHeaders.get(name);
        return value == null ? null : value.toString();
    }

    @NonNull
    public MockContext setResponseHeader(@NonNull String name, @NonNull String value) {
        this.responseHeaders.put(name, value);
        return this;
    }

    @NonNull
    public MockContext setResponseLength(long length) {
        this.response.setContentLength(length);
        return this;
    }

    public long getResponseLength() {
        return this.response.getContentLength();
    }

    @NonNull
    public MockContext setResponseType(@NonNull String contentType) {
        this.response.setContentType(MediaType.valueOf((String)contentType));
        return this;
    }

    @NonNull
    public MockContext setResponseType(@NonNull MediaType contentType, @Nullable Charset charset) {
        this.response.setContentType(contentType);
        return this;
    }

    @NonNull
    public MockContext setResponseCode(int statusCode) {
        this.response.setStatusCode(StatusCode.valueOf((int)statusCode));
        return this;
    }

    @NonNull
    public StatusCode getResponseCode() {
        return this.response.getStatusCode();
    }

    @NonNull
    public MockContext render(@NonNull Object result) {
        this.responseStarted = true;
        this.response.setResult(result);
        return this;
    }

    @NonNull
    public MockResponse getResponse() {
        this.response.setHeaders(this.responseHeaders);
        return this.response;
    }

    @NonNull
    public OutputStream responseStream() {
        this.responseStarted = true;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        this.response.setResult(out);
        return out;
    }

    @NonNull
    public Sender responseSender() {
        this.responseStarted = true;
        return new Sender(){

            public Sender write(@NonNull byte[] data, @NonNull Sender.Callback callback) {
                MockContext.this.response.setResult(data);
                callback.onComplete((Context)MockContext.this, null);
                return this;
            }

            public void close() {
                MockContext.this.listeners.run((Context)MockContext.this);
            }
        };
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    @NonNull
    public Context setHost(@NonNull String host) {
        this.host = host;
        return this;
    }

    @NonNull
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @NonNull
    public Context setRemoteAddress(@NonNull String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @NonNull
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @NonNull
    public List<Certificate> getClientCertificates() {
        return new ArrayList<Certificate>();
    }

    @NonNull
    public String getScheme() {
        return this.scheme;
    }

    @NonNull
    public Context setScheme(@NonNull String scheme) {
        this.scheme = scheme;
        return this;
    }

    @NonNull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.responseStarted = true;
        PrintWriter writer = new PrintWriter(new StringWriter());
        this.response.setResult(writer).setContentType(type);
        return writer;
    }

    @NonNull
    public MockContext send(@NonNull String data, @NonNull Charset charset) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.length());
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(@NonNull byte[] data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.length);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(byte[] ... data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(IntStream.range(0, data.length).map(i -> data[i].length).sum());
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(@NonNull ByteBuffer data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.remaining());
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public Context send(@NonNull ByteBuffer[] data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(IntStream.range(0, data.length).map(i -> data[i].remaining()).sum());
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(InputStream input) {
        this.responseStarted = true;
        this.response.setResult(input);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public Context send(@NonNull FileDownload file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public Context send(@NonNull Path file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(@NonNull ReadableByteChannel channel) {
        this.responseStarted = true;
        this.response.setResult(channel);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(@NonNull FileChannel file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext send(StatusCode statusCode) {
        this.responseStarted = true;
        this.response.setContentLength(0L).setStatusCode(statusCode);
        return this;
    }

    @NonNull
    public MockContext sendError(@NonNull Throwable cause) {
        return this.sendError(cause, this.router.errorCode(cause));
    }

    @NonNull
    public MockContext sendError(@NonNull Throwable cause, @NonNull StatusCode code) {
        this.responseStarted = true;
        this.response.setResult(cause).setStatusCode(this.router.errorCode(cause));
        this.listeners.run((Context)this);
        return this;
    }

    @NonNull
    public MockContext setDefaultResponseType(@NonNull MediaType contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    @NonNull
    public MockContext setResponseCookie(@NonNull Cookie cookie) {
        Object setCookie = (String)this.response.getHeaders().get("Set-Cookie");
        setCookie = setCookie == null ? cookie.toCookieString() : (String)setCookie + ";" + cookie.toCookieString();
        this.response.setHeader("Set-Cookie", (String)setCookie);
        return this;
    }

    @NonNull
    public MediaType getResponseType() {
        return this.response.getContentType();
    }

    @NonNull
    public MockContext setResponseCode(@NonNull StatusCode statusCode) {
        this.response.setStatusCode(statusCode);
        return this;
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError;
    }

    public MockContext setResetHeadersOnError(boolean resetHeadersOnError) {
        this.resetHeadersOnError = resetHeadersOnError;
        return this;
    }

    @NonNull
    public Context removeResponseHeaders() {
        this.responseHeaders.clear();
        return this;
    }

    @NonNull
    public Router getRouter() {
        return this.router;
    }

    @NonNull
    public MockContext setRouter(@NonNull Router router) {
        this.router = router;
        return this;
    }

    @NonNull
    public <T> T convert(@NonNull ValueNode value, @NonNull Class<T> type) {
        return (T)super.convert(value, type);
    }

    @NonNull
    public MockContext upgrade(@NonNull WebSocket.Initializer handler) {
        return this;
    }

    @NonNull
    public Context upgrade(@NonNull ServerSentEmitter.Handler handler) {
        return this;
    }

    @NonNull
    public Context onComplete(@NonNull Route.Complete task) {
        this.listeners.addListener(task);
        return this;
    }

    public String toString() {
        return this.method + " " + this.requestPath;
    }

    void setConsumer(Consumer<MockResponse> consumer) {
        this.consumer = consumer;
    }

    void setMockRouter(MockRouter mockRouter) {
        this.mockRouter = mockRouter;
    }
}

