/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Context;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.test.MockWebSocketConfigurer;
import java.util.Collections;
import java.util.List;

public class MockWebSocket
implements WebSocket {
    private final MockWebSocketConfigurer configurer;
    private Context ctx;
    private boolean open = true;

    MockWebSocket(Context ctx, MockWebSocketConfigurer configurer) {
        this.ctx = ctx;
        this.configurer = configurer;
    }

    @NonNull
    public Context getContext() {
        return this.ctx;
    }

    @NonNull
    public List<WebSocket> getSessions() {
        return Collections.emptyList();
    }

    public boolean isOpen() {
        return this.open;
    }

    public void forEach(SneakyThrows.Consumer<WebSocket> callback) {
        callback.accept((Object)this);
    }

    @NonNull
    public WebSocket send(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(message, callback);
    }

    @NonNull
    public WebSocket send(@NonNull byte[] message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(message, callback);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull String message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(message, callback);
    }

    @NonNull
    public WebSocket sendBinary(@NonNull byte[] message, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(message, callback);
    }

    @NonNull
    public WebSocket render(@NonNull Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(value, callback);
    }

    @NonNull
    public WebSocket renderBinary(@NonNull Object value, @NonNull WebSocket.WriteCallback callback) {
        return this.sendObject(value, callback);
    }

    @NonNull
    public WebSocket close(@NonNull WebSocketCloseStatus closeStatus) {
        try {
            this.open = false;
            this.configurer.fireClose(closeStatus);
        }
        catch (Throwable x) {
            this.handleError(x);
        }
        return this;
    }

    private WebSocket sendObject(Object message, WebSocket.WriteCallback callback) {
        block4: {
            try {
                if (this.open) {
                    this.configurer.fireClientMessage(message);
                    if (callback != null) {
                        callback.operationComplete((WebSocket)this, null);
                    }
                    break block4;
                }
                throw new IllegalStateException("Attempt to send a message on closed web socket");
            }
            catch (Throwable x) {
                this.handleError(x);
                if (callback == null) break block4;
                callback.operationComplete((WebSocket)this, x);
            }
        }
        return this;
    }

    private void handleError(Throwable error) {
        this.configurer.fireError(error);
        if (SneakyThrows.isFatal((Throwable)error)) {
            throw SneakyThrows.propagate((Throwable)error);
        }
    }
}

